/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.dao;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationEntity;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthenticationImpl;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentications;
import com.atlassian.bamboo.buildqueue.dao.RemoteAgentAuthenticationDao;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RemoteAgentAuthenticationHibernateDao
extends BambooHibernateObjectDao<RemoteAgentAuthenticationEntity>
implements RemoteAgentAuthenticationDao {
    private static final Class<RemoteAgentAuthenticationEntity> PERSISTENT_CLASS = RemoteAgentAuthenticationImpl.class;

    @NotNull
    public RemoteAgentAuthenticationEntity saveAndReturn(RemoteAgentAuthenticationEntity authentication) {
        this.save(authentication);
        return authentication;
    }

    @NotNull
    public Collection<RemoteAgentAuthenticationEntity> getAllAuthentications() {
        return (Collection)this.getHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).list());
    }

    public void approve(Iterable<RemoteAgentAuthenticationEntity> authentications) {
        if (Iterables.isEmpty(authentications)) {
            return;
        }
        List<RemoteAgentAuthenticationEntity> existingAuthentications = this.getExistingMatchingAuthentications(authentications);
        ImmutableList.Builder toSave = ImmutableList.builder();
        for (RemoteAgentAuthenticationEntity authentication : authentications) {
            RemoteAgentAuthenticationEntity existing = (RemoteAgentAuthenticationEntity)Iterables.find(existingAuthentications, (Predicate)RemoteAgentAuthentications.matching((UUID)authentication.getUuid()), null);
            if (existing != null) {
                existing.setIp(authentication.getIp());
                existing.setApproved(true);
                toSave.add((Object)existing);
                continue;
            }
            authentication.setApproved(true);
            toSave.add((Object)authentication);
        }
        this.saveAll(toSave.build());
    }

    private List<RemoteAgentAuthenticationEntity> getExistingMatchingAuthentications(Iterable<RemoteAgentAuthenticationEntity> authentications) {
        List uuidStrings = ImmutableList.copyOf(authentications).stream().map(RemoteAgentAuthentications.getUuidAsString()).collect(Collectors.toList());
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("findByUuids", "uuids", uuidStrings);
    }
}

