/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.capability;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.capability.CapabilityDao;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.PlanDiscriminatorRegistry;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityAgentMapping;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityElasticImageMapping;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityEphemeralAgentTemplateMapping;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementPlanMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class CapabilityDaoImpl
extends BambooHibernateObjectDao<Capability>
implements CapabilityDao {
    private static final Logger log = Logger.getLogger(CapabilityDaoImpl.class);
    private static final Class<? extends Capability> PERSISTENT_CLASS = CapabilityImpl.class;
    private PlanDiscriminatorRegistry planDiscriminatorRegistry;

    @NotNull
    public List<CapabilityAgentMapping> getCapabilitiesFromKey(@NotNull String capabilityKey) {
        ArrayList<CapabilityAgentMapping> result = new ArrayList<CapabilityAgentMapping>();
        result.addAll(this.getHibernateTemplate().findByNamedQueryAndNamedParam("findCapabilitiesOfLocalAgentsByKey", "capabilityKey", (Object)capabilityKey));
        result.addAll(this.getHibernateTemplate().findByNamedQueryAndNamedParam("findCapabilitiesOfRemoteAgentsByKey", "capabilityKey", (Object)capabilityKey));
        result.addAll(this.getHibernateTemplate().findByNamedQueryAndNamedParam("findSharedCapabilitiesByKey", "capabilityKey", (Object)capabilityKey));
        return result;
    }

    @NotNull
    public List<CapabilityElasticImageMapping> getElasticImageCapabilitiesFromKey(@NotNull AwsSupportConstants.Region region, @NotNull String capabilityKey) {
        return (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findElasticImageCapabilitiesByKey").setParameter("region", (Object)region).setParameter("capabilityKey", (Object)capabilityKey).list());
    }

    public List<CapabilityEphemeralAgentTemplateMapping> getEphemeralAgentTemplateCapabilitiesFromKey(@NotNull String capabilityKey) {
        return (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findEphemeralAgentTemplateCapabilitiesByKey").setParameter("capabilityKey", (Object)capabilityKey).list());
    }

    @NotNull
    public List<Long> getAgentIdsFromKey(@NotNull String capabilityKey) {
        ArrayList<Long> result = new ArrayList<Long>();
        result.addAll(this.getHibernateTemplate().findByNamedQueryAndNamedParam("findLocalAgentIdsByKey", "capabilityKey", (Object)capabilityKey));
        result.addAll(this.getHibernateTemplate().findByNamedQueryAndNamedParam("findRemoteAgentIdsByKey", "capabilityKey", (Object)capabilityKey));
        return result;
    }

    @NotNull
    public List<RequirementPlanMapping> getRequirementsFromKey(@NotNull String requirementKey) {
        List list = (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findRequirementsByKey").setParameter("requirementKey", (Object)requirementKey).setParameter("markedForDeletion", (Object)false).list());
        return new ArrayList<RequirementPlanMapping>(new HashSet(list));
    }

    @NotNull
    public List<Pair<Requirement, PlanKey>> getImmutablePlansKeysByRequirementKey(@NotNull String requirementKey) {
        List list = (List)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findRequirementsByKey2").setParameter("requirementKey", (Object)requirementKey).setParameter("markedForDeletion", (Object)false).list());
        return new ArrayList<Pair<Requirement, PlanKey>>(new HashSet(list));
    }

    @NotNull
    public Collection<Capability> findCapabilitiesMatchingPrefix(final @NotNull String capabilityKeyPrefix) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Capability>>(){

            public List<Capability> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(CapabilityImpl.class).add((Criterion)Restrictions.like((String)"key", (String)capabilityKeyPrefix, (MatchMode)MatchMode.START)).list();
            }
        });
    }

    @Nullable
    public Capability getCapability(@NotNull Long capabilityId) {
        return this.findById(capabilityId, PERSISTENT_CLASS);
    }

    public void removeCapability(@NotNull Long capabilityId) {
        Capability capability = this.findById(capabilityId, PERSISTENT_CLASS);
        if (capability != null) {
            CapabilitySet set = capability.getCapabilitySet();
            if (set != null) {
                set.removeCapability(capability.getKey());
            }
            this.delete(capability);
        }
    }

    public void updateCapability(@NotNull Long capabilityId, @NotNull String value) {
        this.getHibernateTemplate().execute(session -> {
            CapabilityImpl capability = (CapabilityImpl)session.get(PERSISTENT_CLASS, (Serializable)capabilityId);
            capability.setValue(value);
            session.saveOrUpdate((Object)capability);
            return capability;
        });
    }

    public void setPlanDiscriminatorRegistry(PlanDiscriminatorRegistry planDiscriminatorRegistry) {
        this.planDiscriminatorRegistry = planDiscriminatorRegistry;
    }
}

