/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.capability;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.capability.CapabilitySetDao;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetImpl;
import com.atlassian.core.bean.EntityObject;
import java.util.Collection;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class CapabilityHibernateSetDao
extends BambooHibernateObjectDao
implements CapabilitySetDao {
    public Class getPersistentClass() {
        return CapabilitySetImpl.class;
    }

    @Nullable
    public PipelineDefinition getPipelineDefinition(@NotNull CapabilitySet capabilitySet) {
        PipelineDefinition localDefinition = (PipelineDefinition)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findLocalAgentByCapabilitySet").setParameter("capabilitySetId", (Object)capabilitySet.getId()).uniqueResult());
        if (localDefinition == null) {
            localDefinition = (PipelineDefinition)this.getHibernateTemplate().execute(session -> session.getNamedQuery("findRemoteAgentByCapabilitySet").setParameter("capabilitySetId", (Object)capabilitySet.getId()).uniqueResult());
        }
        return localDefinition;
    }

    @Nullable
    public ElasticImageConfiguration getElasticImageConfiguration(final @NotNull CapabilitySet capabilitySet) {
        return (ElasticImageConfiguration)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findElasticImageByCapabilitySet").setParameter("capabilitySetId", (Object)capabilitySet.getId()).uniqueResult();
            }
        });
    }

    public CapabilitySet getSharedCapabilitySet() {
        return (CapabilitySet)this.getHibernateTemplate().execute(session -> (CapabilitySet)session.createCriteria(this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"capabilityScope", (Object)CapabilityScope.SHARED)).uniqueResult());
    }

    @NotNull
    public List<String> findUniqueCapabilityKeys() {
        return this.getHibernateTemplate().findByNamedQuery("findUniqueCapabilityKeys", new Object[0]);
    }

    @NotNull
    public Collection<Capability> getSystemCapabilities(String type) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam("findSystemCapabilities", "systemPrefix", (Object)("system." + type + "%"));
    }

    @NotNull
    public Collection<String> getSystemKeysExcludingElasticByType(@NotNull String type) {
        return this.getSystemKeysByType("findSystemKeysExcludingElasticByType", type);
    }

    @NotNull
    public Collection<String> getAllSystemKeysByType(@NotNull String type) {
        return this.getSystemKeysByType("findAllSystemKeysByType", type);
    }

    @NotNull
    private Collection<String> getSystemKeysByType(String queryName, String type) {
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, "type", (Object)("system." + type + "%"));
    }

    @NotNull
    public Collection<Capability> getSystemCapabilitiesByKey(String key) {
        return (Collection)this.getHibernateTemplate().execute(session -> session.createCriteria(CapabilityImpl.class).add((Criterion)Restrictions.eq((String)"key", (Object)key)).list());
    }

    public void saveCapabilitySet(CapabilitySet capabilitySet) {
        this.save((EntityObject)capabilitySet);
    }
}

