/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageDao;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.chains.ChainStageImpl_;
import com.atlassian.bamboo.chains.ChainStageTuple;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateVersionAwareObjectDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.utils.collection.multimap.Multimap;
import com.atlassian.bamboo.versioning.PlanVersioningSupplement;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class ChainStageHibernateDao
extends BambooHibernateVersionAwareObjectDao<ChainStage, Plan>
implements ChainStageDao {
    private static final Class<? extends ChainStage> PERSISTENT_CLASS = ChainStageImpl.class;
    private static final BambooEntityType ENTITY_TYPE = BambooEntityType.STAGE;
    private final VersioningSupplement<Plan> versioningSupplement;

    @Inject
    public ChainStageHibernateDao(@NotNull BambooClusterSettings bambooClusterSettings) {
        this.versioningSupplement = new PlanVersioningSupplement(bambooClusterSettings);
    }

    @Override
    @NotNull
    protected Optional<VersioningSupplement<Plan>> getRootVersioningSupplement() {
        return Optional.of(this.versioningSupplement);
    }

    @NotNull
    public Multimap<PlanKey, Long> getChainStagesMarkedForDeletion() {
        List list = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ChainStageTuple>>(){

            public List<ChainStageTuple> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findStageIdAndPlanKey").setParameter("markedForDeletion", (Object)true).list();
            }
        });
        return ChainStageTuple.groupByPlanKey(list);
    }

    public long getChainStageCount() {
        return this.countAll(PERSISTENT_CLASS);
    }

    public long getManualChainStageCount() {
        return this.countWithRestriction(PERSISTENT_CLASS, (Criterion)Restrictions.eq((String)"manual", (Object)true));
    }

    @Nullable
    public BambooEntityOid getMaxStageOid(int serverKey) {
        return (BambooEntityOid)this.getHibernateTemplate().execute(session -> (BambooEntityOid)session.createCriteria(PERSISTENT_CLASS).add(Restrictions.between((String)"oid", (Object)BambooEntityOid.minOidOfType((int)serverKey, (BambooEntityType)ENTITY_TYPE), (Object)BambooEntityOid.maxOidOfType((int)serverKey, (BambooEntityType)ENTITY_TYPE))).setProjection((Projection)Projections.max((String)"oid")).uniqueResult());
    }

    public void markForDeletion(@NotNull ImmutableChainStage chainStage) {
        if (chainStage.getDatabaseId().isEmpty()) {
            return;
        }
        long chainStageId = chainStage.getId();
        this.pureMarkForDeletion(chainStageId);
        this.incrementRootVersionByChainStageId(chainStageId);
    }

    private void pureMarkForDeletion(final long chainStageId) {
        new JpaUtils.CriteriaUpdate<ChainStageImpl>(this.getSessionFactory(), ChainStageImpl.class){

            @Override
            public void apply() {
                this.update.set(this.entity.get(ChainStageImpl_.markedForDeletion), (Object)true).where((Expression)this.cb.equal((Expression)this.entity.get(ChainStageImpl_.id), (Object)chainStageId));
            }
        }.executeUpdate();
    }

    private void incrementRootVersionByChainStageId(final long chainStageId) {
        new JpaUtils.CriteriaVersionUpdater<ChainStageImpl, ChainStage, Plan>(this.getSessionFactory(), ChainStageImpl.class, ChainStage.class, this.versioningSupplement){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get(ChainStageImpl_.id), (Object)chainStageId));
            }
        }.incrementRootVersion();
    }
}

