/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.utils.collection.multimap.LinkedSetMultimap;
import com.google.common.collect.Ordering;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Internal
public class ChainStageTuple
implements Comparable<ChainStageTuple> {
    final Long stageId;
    final PlanKey planKey;
    final Long masterPlanId;

    public ChainStageTuple(Long stageId, PlanKey planKey, Long masterPlanId) {
        this.masterPlanId = masterPlanId;
        this.stageId = stageId;
        this.planKey = planKey;
    }

    public static LinkedSetMultimap<PlanKey, Long> groupByPlanKey(List<ChainStageTuple> list) {
        LinkedSetMultimap multimap = LinkedSetMultimap.create();
        List lists = Ordering.natural().sortedCopy(list);
        for (ChainStageTuple tuple : lists) {
            multimap.put((Object)tuple.planKey, (Object)tuple.stageId);
        }
        return multimap;
    }

    @Override
    public int compareTo(ChainStageTuple o) {
        return new CompareToBuilder().append((Object)o.masterPlanId, (Object)this.masterPlanId).append((Object)this.planKey, (Object)o.planKey).append((Object)this.stageId, (Object)o.stageId).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 7).append((Object)this.masterPlanId).append((Object)this.planKey).append((Object)this.stageId).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChainStageTuple)) {
            return false;
        }
        ChainStageTuple rhs = (ChainStageTuple)o;
        return new EqualsBuilder().append((Object)this.masterPlanId, (Object)rhs.masterPlanId).append((Object)this.planKey, (Object)rhs.planKey).append((Object)this.stageId, (Object)rhs.stageId).isEquals();
    }

    public String toString() {
        return "ChainStageTuple{masterPlanId=" + this.masterPlanId + ", stageId=" + this.stageId + ", planKey=" + this.planKey + "}";
    }
}

