/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.comment;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentDao;
import com.atlassian.bamboo.comment.CommentImpl;
import com.atlassian.bamboo.comment.CommentImpl_;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persistence3.DeletionSQLAdapter;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.utils.db.JdbcUtils;
import com.google.common.collect.Ordering;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class CommentHibernateDao
extends BambooHibernateObjectDao<Comment>
implements CommentDao {
    private static final Logger log = LogManager.getLogger(CommentHibernateDao.class);
    private static final Class<? extends Comment> PERSISTENT_CLASS = CommentImpl.class;
    private static final String FIELD_CREATION_DATE = "creationDate";
    private final TransactionAndHibernateTemplate transactionTemplate;

    public CommentHibernateDao(TransactionAndHibernateTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public Comment findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @NotNull
    public List<Comment> getCommentsForEntity(final long entityId) {
        return new JpaUtils.CriteriaQuery<CommentImpl, Comment>(this.getSessionFactory(), CommentImpl.class, Comment.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get("entityId"), (Object)entityId)).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get(CommentHibernateDao.FIELD_CREATION_DATE))});
            }
        }.getResultList();
    }

    public void deleteByEntityId(final long entityId) {
        new JpaUtils.CriteriaDelete<CommentImpl>(this.getSessionFactory(), CommentImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("entityId"), (Object)entityId));
            }
        }.executeUpdate();
    }

    @NotNull
    public List<Comment> findCommentByUser(final String userName) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Comment>>(){

            public List<Comment> doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery("findCommentByUser").setParameter("userName", (Object)userName);
                BambooSessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)CommentHibernateDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @NotNull
    public List<Comment> getCommentsForBuildResults(final @NotNull PlanKey planKey) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Comment>>(){

            public List<Comment> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("getCommentsForBuildResults").setParameter("planKey", (Object)planKey.getKey());
                BambooSessionFactoryUtils.applyTransactionTimeout((Query)query, (SessionFactory)CommentHibernateDao.this.getSessionFactory());
                return query.list();
            }
        });
    }

    @NotNull
    public List<Comment> getCommentsForJobResults(final @NotNull ChainResultsSummary chainResultsSummary) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Comment>>(){

            public List<Comment> doInHibernate(Session session) throws HibernateException {
                Query query = session.getNamedQuery("getCommentsForChainResultChildren").setParameter("chainResultSummary", (Object)chainResultsSummary);
                BambooSessionFactoryUtils.applyTransactionTimeout((Query)query, (SessionFactory)CommentHibernateDao.this.getSessionFactory());
                return query.list();
            }
        });
    }

    public void anonymizeUserComments(final @NotNull String username) {
        int numberOfAnonymizedComments = new JpaUtils.CriteriaUpdate<CommentImpl>(this.getSessionFactory(), CommentImpl.class){

            @Override
            public void apply() {
                this.update.set(this.entity.get(CommentImpl_.userName), (Object)"").where((Expression)this.cb.equal((Expression)this.entity.get(CommentImpl_.userName), (Object)username));
            }
        }.executeUpdate();
        log.debug("Anonymized {} comments for user {}", (Object)numberOfAnonymizedComments, (Object)username);
    }

    public long scrollCommentsForExport(final @NotNull Consumer<Comment> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(10, ScrollMode.FORWARD_ONLY){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportComments");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                CommentImpl comment = (CommentImpl)data.get(0);
                consumer.accept(comment);
                session.evict((Object)comment);
            }
        });
    }

    public int deleteByEntityId(@NotNull DeletionSQLAdapter deletionAdapter) {
        final String SQL_DELETE = String.format("delete from USER_COMMENT where ENTITY_ID in (%s)", deletionAdapter.getInClause());
        final AtomicInteger result = new AtomicInteger();
        this.transactionTemplate.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                result.set(JdbcUtils.runDeleteQuery(connection, SQL_DELETE, "Comment"));
            }
        });
        return result.get();
    }

    private Ordering<Comment> orderingByReverseUpdateDate() {
        return OrderingByReverseUpdateDate.ORDERING;
    }

    private static enum OrderingByReverseUpdateDate implements Comparator<Comment>
    {
        INSTANCE;

        private static final Ordering<Comment> ORDERING;

        @Override
        public int compare(Comment o1, Comment o2) {
            return o2.getLastModificationDate().compareTo(o1.getLastModificationDate());
        }

        static {
            ORDERING = Ordering.from((Comparator)INSTANCE);
        }
    }
}

