/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.commit;

import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitDao;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.commit.UnassociatedCommit;
import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public class CommitHibernateDao
extends BambooHibernateObjectDao<Commit>
implements CommitDao {
    private static final Logger log = Logger.getLogger(CommitHibernateDao.class);
    private static final Class<CommitImpl> PERSISTENT_CLASS = CommitImpl.class;
    private final Supplier<DbmsBean> dbmsBeanRef = ComponentAccessor.DBMS_BEAN;

    public long scrollCommitsForExport(final @NotNull Consumer<Commit> consumer) {
        return (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(10, ScrollMode.FORWARD_ONLY){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("exportCommits");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                CommitImpl commit = (CommitImpl)data.get(0);
                consumer.accept(commit);
                session.evict((Object)commit);
            }
        });
    }

    @NotNull
    public List<Commit> getCommitsForResult(final @NotNull ResultsSummary resultsSummary) {
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Commit>>(){

            public List<Commit> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(PERSISTENT_CLASS).setFetchMode("repositoryChangeset", FetchMode.JOIN).createAlias("repositoryChangeset", "rc").add((Criterion)Restrictions.eq((String)"rc.resultsSummary", (Object)resultsSummary)).list();
            }
        });
    }

    @NotNull
    public List<UnassociatedCommit> getCommitsForUser(final @NotNull String username, final int max) {
        final String queryName = this.dbmsBeanRef.get().getDatabaseType() == DatabaseType.MYSQL ? "commitsForUserWithDistinct" : "commitsForUser";
        return (List)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<UnassociatedCommit>>(){

            public List<UnassociatedCommit> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery(queryName).setParameter("username", Preconditions.checkNotNull((Object)username)).setMaxResults(max).list();
            }
        });
    }
}

