/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.credentials;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.credentials.CredentialsDao;
import com.atlassian.bamboo.credentials.CredentialsDataEntity;
import com.atlassian.bamboo.credentials.CredentialsDataEntity_;
import com.atlassian.bamboo.credentials.MutableCredentialsData;
import com.atlassian.bamboo.hibernate.callbacks.RowCount;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectWithOidDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CredentialsHibernateDao
extends BambooHibernateObjectWithOidDao<MutableCredentialsData>
implements CredentialsDao {
    private static final Class<? extends MutableCredentialsData> PERSISTENT_CLASS = CredentialsDataEntity.class;
    @Inject
    private TransactionAndHibernateTemplate transactionTemplate;

    @NotNull
    public Collection<? extends MutableCredentialsData> findAll(int firstResult, int maxResults) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).setFirstResult(firstResult).setMaxResults(maxResults).addOrder(org.hibernate.criterion.Order.asc((String)"id")).list());
    }

    @NotNull
    public BambooEntityOid getMaxCredentialOid(int serverKey) {
        return (BambooEntityOid)this.getHibernateTemplate().execute(session -> (BambooEntityOid)session.createCriteria(PERSISTENT_CLASS).add(Restrictions.between((String)"oid", (Object)BambooEntityOid.minOidOfType((int)serverKey, (BambooEntityType)BambooEntityType.SHARED_CREDENTIAL), (Object)BambooEntityOid.maxOidOfType((int)serverKey, (BambooEntityType)BambooEntityType.SHARED_CREDENTIAL))).setProjection((Projection)Projections.max((String)"oid")).uniqueResult());
    }

    @Nullable
    public MutableCredentialsData findGlobalByName(String name) {
        return (MutableCredentialsData)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS);
            criteria.setCacheable(true);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
            criteria.add(Restrictions.isNull((String)"projectId"));
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return (MutableCredentialsData)criteria.uniqueResult();
        });
    }

    public MutableCredentialsData findByNameAndProjectId(String name, long projectId) {
        return (MutableCredentialsData)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS);
            criteria.setCacheable(true);
            criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
            criteria.add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId));
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return (MutableCredentialsData)criteria.uniqueResult();
        });
    }

    @NotNull
    public Collection<? extends MutableCredentialsData> findAllByProject(final Long projectId) {
        return new JpaUtils.CriteriaQuery<CredentialsDataEntity, MutableCredentialsData>(this.getSessionFactory(), CredentialsDataEntity.class, MutableCredentialsData.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get("pluginKey")), this.cb.asc((Expression)this.entity.get("name"))}).where((Expression)this.cb.equal((Expression)this.entity.get("projectId"), (Object)projectId));
            }
        }.getResultList();
    }

    @NotNull
    public Collection<? extends MutableCredentialsData> findAllByProjectAndPluginKey(final Long projectId, final String pluginKey) {
        return new JpaUtils.CriteriaQuery<CredentialsDataEntity, MutableCredentialsData>(this.getSessionFactory(), CredentialsDataEntity.class, MutableCredentialsData.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.entity.get("projectId"), (Object)projectId), (Expression)this.cb.equal((Expression)this.entity.get("pluginKey"), (Object)pluginKey))).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get("name"))});
            }
        }.getResultList();
    }

    public boolean hasAnyGlobalCredentials(@NotNull String pluginKey) {
        DetachedCriteria criteria = DetachedCriteria.forClass(PERSISTENT_CLASS).add((Criterion)Property.forName((String)"pluginKey").eq((Object)pluginKey)).add(Property.forName((String)"projectId").isNull());
        return RowCount.execute(this.getHibernateTemplate(), criteria) > 0L;
    }

    @NotNull
    public Collection<? extends MutableCredentialsData> findGlobalAll() {
        return new JpaUtils.CriteriaQuery<CredentialsDataEntity, MutableCredentialsData>(this.getSessionFactory(), CredentialsDataEntity.class, MutableCredentialsData.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get("pluginKey")), this.cb.asc((Expression)this.entity.get("name"))}).where((Expression)this.cb.isNull((Expression)this.entity.get("projectId")));
            }
        }.getResultList();
    }

    @NotNull
    public Long countAllGlobalCredentials() {
        return (Long)new JpaUtils.CriteriaQuery<CredentialsDataEntity, Long>(this.getSessionFactory(), CredentialsDataEntity.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.isNull((Expression)this.entity.get(CredentialsDataEntity_.projectId)));
            }
        }.getSingleResult();
    }

    @NotNull
    public Long countAllProjectsCredentials() {
        return (Long)new JpaUtils.CriteriaQuery<CredentialsDataEntity, Long>(this.getSessionFactory(), CredentialsDataEntity.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity)).where((Expression)this.cb.isNotNull((Expression)this.entity.get(CredentialsDataEntity_.projectId)));
            }
        }.getSingleResult();
    }

    @NotNull
    public List<Long> findAllProjectsIdsUsingProjectSharedCredentials() {
        return new JpaUtils.CriteriaQuery<CredentialsDataEntity, Long>(this.getSessionFactory(), CredentialsDataEntity.class, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity.get(CredentialsDataEntity_.projectId)).where((Expression)this.cb.isNotNull((Expression)this.entity.get(CredentialsDataEntity_.projectId))).distinct(true);
            }
        }.getResultList();
    }

    @NotNull
    public Collection<? extends MutableCredentialsData> findAll() {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(session -> session.createCriteria(PERSISTENT_CLASS).list());
    }

    @Nullable
    public MutableCredentialsData findById(long id) {
        return this.findById(id, PERSISTENT_CLASS);
    }

    @Nullable
    public MutableCredentialsData findByOid(@NotNull BambooEntityOid oid) {
        return this.findByOid(oid, PERSISTENT_CLASS);
    }

    @NotNull
    public MutableCredentialsData merge(@NotNull MutableCredentialsData unmanagedEntity) {
        return this.merge(unmanagedEntity, PERSISTENT_CLASS);
    }

    @NotNull
    public List<MutableCredentialsData> getPaginatedSharedCredentials(final @Nullable Long projectId, int start, int limit, final String filter) {
        final boolean filterIsEmpty = StringUtils.isEmpty((CharSequence)filter);
        return new JpaUtils.CriteriaQuery<CredentialsDataEntity, MutableCredentialsData>(this.getSessionFactory(), CredentialsDataEntity.class, MutableCredentialsData.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.asc((Expression)this.entity.get("pluginKey")), this.cb.asc((Expression)this.entity.get("name"))});
                ArrayList<Predicate> predicatesList = new ArrayList<Predicate>();
                if (projectId != null) {
                    predicatesList.add(this.cb.equal((Expression)this.entity.get("projectId"), (Object)projectId));
                } else {
                    predicatesList.add(this.cb.isNull((Expression)this.entity.get("projectId")));
                }
                if (!filterIsEmpty) {
                    predicatesList.add(this.cb.like((Expression)this.entity.get("name"), "%" + filter + "%"));
                }
                Predicate[] predicates = new Predicate[predicatesList.size()];
                predicatesList.toArray(predicates);
                this.q.where(predicates);
            }
        }.getResultList(start, limit);
    }

    public int deleteByProjectId(final long projectId) {
        return new JpaUtils.CriteriaDelete<CredentialsDataEntity>(this.getSessionFactory(), CredentialsDataEntity.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.equal((Expression)this.entity.get("projectId"), (Object)projectId));
            }
        }.executeUpdate();
    }

    @NotNull
    public List<? extends MutableCredentialsData> findGlobalByPluginKey(@NotNull String pluginKey) {
        return this.findCredentials(pluginKey, true);
    }

    @NotNull
    public List<? extends MutableCredentialsData> findAllByPluginKey(@NotNull String pluginKey) {
        return this.findCredentials(pluginKey, false);
    }

    @NotNull
    private List<? extends MutableCredentialsData> findCredentials(@NotNull String pluginKey, boolean onlyGlobal) {
        return (List)this.getCacheAwareHibernateTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(PERSISTENT_CLASS);
            criteria.setCacheable(true);
            criteria.add((Criterion)Restrictions.eq((String)"pluginKey", (Object)pluginKey));
            if (onlyGlobal) {
                criteria.add(Restrictions.isNull((String)"projectId"));
            }
            criteria.addOrder(org.hibernate.criterion.Order.asc((String)"name"));
            BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
            return criteria.list();
        });
    }
}

