/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate;

import com.atlassian.bamboo.hibernate.DatabaseVersionHolder;
import com.atlassian.bamboo.hibernate.DialectSelector;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.secrets.api.SecretStore;
import com.atlassian.secrets.api.SecretStoreProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooHibernateConfig
extends HibernateConfig {
    private static final Logger log = Logger.getLogger(BambooHibernateConfig.class);
    private static final String DIALECT_PROPERTY = "hibernate.dialect";
    public static final String NON_KEYWORDS = ";NON_KEYWORDS=KEY,VALUE";
    public static final String CIPHER_TYPE_PROP = "jdbc.password.decrypter.classname";
    private SecretStoreProvider secretStoreProvider;
    private final CacheLoader<Pair<String, String>, String> passwordLoader = new CacheLoader<Pair<String, String>, String>(){

        public String load(Pair<String, String> key) {
            Optional secretStoreOptional = BambooHibernateConfig.this.secretStoreProvider.getInstance((String)key.getSecond());
            if (secretStoreOptional.isPresent()) {
                log.debug((Object)("Retrieving database password using " + (String)key.getSecond()));
                SecretStore secretStore = (SecretStore)secretStoreOptional.get();
                return secretStore.get((String)key.getFirst());
            }
            return (String)key.getFirst();
        }
    };
    private final LoadingCache<Pair<String, String>, String> passwordCache = CacheBuilder.newBuilder().maximumSize(1L).build(this.passwordLoader);

    public Properties getHibernateProperties() {
        String url;
        String configuredDialect;
        String detectedDialect;
        Properties hibernateProperties = super.getHibernateProperties();
        Object cipherType = this.getApplicationConfig().getProperty((Object)CIPHER_TYPE_PROP);
        if (cipherType != null && StringUtils.isNotBlank((CharSequence)hibernateProperties.getProperty("hibernate.connection.password"))) {
            String password = hibernateProperties.getProperty("hibernate.connection.password");
            password = this.decryptPassword(password, cipherType.toString());
            hibernateProperties.setProperty("hibernate.connection.password", password);
        }
        if ((detectedDialect = DialectSelector.getDialect(configuredDialect = hibernateProperties.getProperty(DIALECT_PROPERTY))) == null) {
            log.info((Object)("Unable to detect dialect, returning the configured value of " + configuredDialect));
        }
        if (detectedDialect != null && !configuredDialect.equals(detectedDialect)) {
            log.debug((Object)("Overriding configured dialect " + configuredDialect + " with " + detectedDialect));
            hibernateProperties.setProperty(DIALECT_PROPERTY, detectedDialect);
        }
        if (StringUtils.startsWith((CharSequence)(url = hibernateProperties.getProperty("hibernate.connection.url")), (CharSequence)"jdbc:h2") && !url.contains(";")) {
            hibernateProperties.setProperty("hibernate.connection.url", url + NON_KEYWORDS);
        }
        if (!DatabaseVersionHolder.isInitialised()) {
            return hibernateProperties;
        }
        if (!hibernateProperties.containsKey("hibernate.globally_quoted_identifiers") && DatabaseVersionHolder.getDatabaseType() == DatabaseType.MSSQL) {
            hibernateProperties.setProperty("hibernate.globally_quoted_identifiers", Boolean.TRUE.toString());
        }
        return hibernateProperties;
    }

    public void setSecretStoreProvider(SecretStoreProvider secretStoreProvider) {
        this.secretStoreProvider = secretStoreProvider;
    }

    public String decryptPassword(@NotNull String password, @Nullable String decrypterClassName) {
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)decrypterClassName)) {
            return password;
        }
        return (String)this.passwordCache.getUnchecked((Object)Pair.make((Object)password, (Object)decrypterClassName));
    }
}

