/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate;

import bucket.core.persistence.hibernate.schema.MetadataImplementorHolder;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.config.ConfigurationException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.jdbc.Work;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class BambooSchemaHelper {
    private static final Logger log = Logger.getLogger(BambooSchemaHelper.class);
    @Lazy
    @Autowired
    private HibernateTemplate hibernateTemplate;
    @Lazy
    @Autowired
    private DbmsBean dbmsBean;

    public void updateSchemaIfNeeded(boolean showDDL) throws ConfigurationException {
        try {
            MetadataImplementor metadata = MetadataImplementorHolder.getMetadataImplementor();
            SchemaUpdate schemaUpdate = new SchemaUpdate();
            BambooHibernateUtils.withSqlLogged(() -> schemaUpdate.execute(BambooSchemaHelper.getTargetTypes(true, true), (Metadata)metadata), (String)"Updating schema");
            BambooSchemaHelper.handleExceptions(schemaUpdate);
            this.applySchemaFixups(true);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public static void handleExceptions(SchemaUpdate schemaUpdate) throws Exception {
        List exceptions = schemaUpdate.getExceptions();
        for (Exception ex : exceptions) {
            log.warn((Object)"", (Throwable)ex);
        }
        if (!exceptions.isEmpty()) {
            throw (Exception)exceptions.iterator().next();
        }
    }

    public void dropTables(boolean showDDL) throws ConfigurationException {
        try {
            MetadataImplementor metadata = MetadataImplementorHolder.getMetadataImplementor();
            BambooSchemaHelper.newSchemaExport().drop(BambooSchemaHelper.getTargetTypes(showDDL, true), (Metadata)metadata);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    public void createTables(boolean showDDL) throws ConfigurationException {
        try {
            MetadataImplementor metadata = MetadataImplementorHolder.getMetadataImplementor();
            BambooSchemaHelper.newSchemaExport().create(BambooSchemaHelper.getTargetTypes(showDDL, true), (Metadata)metadata);
            this.applySchemaFixups(false);
        }
        catch (Exception e) {
            throw new ConfigurationException("Cannot update schema", (Throwable)e);
        }
    }

    @NotNull
    private static SchemaExport newSchemaExport() {
        return new SchemaExport();
    }

    public void applySchemaFixups() {
        this.applySchemaFixups(false);
    }

    private void applySchemaFixups(boolean ignoreErrors) {
        if (ignoreErrors) {
            log.info((Object)"Applying schema fixups, it's safe to ignore any problems listed below...");
        } else {
            log.info((Object)"Applying schema fixups...");
        }
        this.hibernateTemplate.execute(session -> {
            BambooSchemaHelper.doWork(session, c -> this.dbmsBean.changeColumnToNotNull(c, "BRS_ARTIFACT_LINK", "ARTIFACT_ID"), ignoreErrors);
            return null;
        });
    }

    private static void doWork(Session session, Work work, boolean quietly) throws HibernateException {
        try {
            session.doWork(work);
            BambooHibernateUtils.flushIfNeeded((Session)session);
            session.doWork(Connection::commit);
        }
        catch (HibernateException e) {
            session.doWork(Connection::rollback);
            if (quietly) {
                log.info((Object)e.toString());
            }
            throw e;
        }
    }

    public static EnumSet<TargetType> getTargetTypes(boolean script, boolean export) {
        ArrayList<TargetType> targets = new ArrayList<TargetType>();
        if (script) {
            targets.add(TargetType.STDOUT);
        }
        if (export) {
            targets.add(TargetType.DATABASE);
        }
        return EnumSet.copyOf(targets);
    }
}

