/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.util.Version;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.google.common.base.Preconditions;
import org.jetbrains.annotations.NotNull;

@Internal
public final class DatabaseVersionHolder {
    private static volatile DatabaseType databaseType;
    private static volatile Version version;

    private DatabaseVersionHolder() {
    }

    public static DatabaseType getDatabaseType() {
        Preconditions.checkState((boolean)DatabaseVersionHolder.isInitialised());
        return databaseType;
    }

    public static void setDatabaseType(DatabaseType databaseType) {
        Preconditions.checkNotNull((Object)databaseType);
        DatabaseVersionHolder.databaseType = databaseType;
    }

    public static Version getVersion() {
        Preconditions.checkState((boolean)DatabaseVersionHolder.isInitialised());
        return version;
    }

    public static void setVersion(@NotNull Version actualVersion) {
        Preconditions.checkNotNull((Object)actualVersion);
        version = actualVersion;
    }

    static boolean isInitialised() {
        return databaseType != null && version != null;
    }
}

