/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate;

import com.atlassian.bamboo.hibernate.DatabaseVersionHolder;
import com.atlassian.bamboo.hibernate.H2NoClobDialect;
import com.atlassian.bamboo.hibernate.SQLServerIntlDialect;
import com.atlassian.bamboo.hibernate.postgresql.PostgreSQL10TextClobDialect;
import com.atlassian.bamboo.util.Version;
import com.atlassian.bamboo.utils.db.DatabaseType;
import org.apache.log4j.Logger;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQL57InnoDBDialect;
import org.hibernate.dialect.MySQL5InnoDBDialect;
import org.hibernate.dialect.MySQL8Dialect;
import org.hibernate.dialect.Oracle12cDialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DialectSelector {
    private static final Logger log = Logger.getLogger(DialectSelector.class);

    @Nullable
    public static String getDialect(@NotNull DatabaseType databaseType, @NotNull Version version) {
        Class<? extends Dialect> dialectClass = DialectSelector.getDialectClass(databaseType, version);
        if (dialectClass == null) {
            return null;
        }
        return dialectClass.getName();
    }

    public static String getDialect(String configuredDialect) {
        if (DatabaseVersionHolder.isInitialised()) {
            return DialectSelector.getDialect(DatabaseVersionHolder.getDatabaseType(), DatabaseVersionHolder.getVersion());
        }
        if (configuredDialect.contains("PostgreSQL")) {
            return PostgreSQL10TextClobDialect.class.getName();
        }
        return configuredDialect;
    }

    @Nullable
    private static Class<? extends Dialect> getDialectClass(@NotNull DatabaseType databaseType, @NotNull Version version) {
        return switch (databaseType) {
            case DatabaseType.MSSQL -> SQLServerIntlDialect.class;
            case DatabaseType.MYSQL -> DialectSelector.selectMySqlDialect(version);
            case DatabaseType.ORACLE -> Oracle12cDialect.class;
            case DatabaseType.POSTGRESQL -> PostgreSQL10TextClobDialect.class;
            case DatabaseType.H2 -> H2NoClobDialect.class;
            default -> null;
        };
    }

    private static Class<? extends Dialect> selectMySqlDialect(@NotNull Version actualVersion) {
        if (actualVersion.isLessThan(new Version(5, 7, 0))) {
            return MySQL5InnoDBDialect.class;
        }
        if (actualVersion.isLessThan(new Version(8))) {
            return MySQL57InnoDBDialect.class;
        }
        return MySQL8Dialect.class;
    }
}

