/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate;

import com.atlassian.bamboo.bandana.BandanaItem;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.user.LoginInformationImpl;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.utils.web.HttpServletRequestMatcher;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.tombstone.UserMembershipTombstone;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.sal.api.xsrf.XsrfHeaderValidator;
import com.atlassian.user.impl.hibernate3.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate3.DefaultHibernateUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.CallbackException;
import org.hibernate.type.Type;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate.support.ChainedInterceptorSupport;

public class ReadOnlyGetMethodEnforcer
extends ChainedInterceptorSupport {
    private static final String AUTO_GROUPS_ADDED = "autoGroupsAdded";
    private static final XsrfHeaderValidator XSRF_HEADER_VALIDATOR = new XsrfHeaderValidator();
    private static final List<Matcher<? super HttpServletRequest>> XSRF_WHITELIST = ImmutableList.builder().add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/applinks/auth/conf/oauth/")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/applinks/auth/conf/trusted/")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/applinks/oauth/login-dance/")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/setup/setupAdminUser.action").build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/setup/setupSelectImport.action").build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo("/oauth/authorize").build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo("/oauth/consumer-info").build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/rest/stp/1.0/license/status").build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/rest/nps/1.0/config").build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/embedded-crowd/directories/moveUp")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/embedded-crowd/directories/moveDown")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/embedded-crowd/directories/disable")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/embedded-crowd/directories/enable")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/embedded-crowd/directories/remove")).build()).add((Object)HttpServletRequestMatcher.builder().servletPath("/plugins/servlet").pathInfo(CoreMatchers.startsWith((String)"/oidc/callback")).build()).build();
    private static final List<Matcher<? super String>> BANDANA_KEY_WHITELIST = ImmutableList.of((Object)Matchers.startsWith((String)"com.atlassian.oauth.consumer.ConsumerTokenStore.consumerKeys."), (Object)Matchers.startsWith((String)"com.atlassian.oauth.consumer.ConsumerTokenStore.keys."), (Object)Matchers.startsWith((String)"com.atlassian.oauth.consumer.ConsumerService:"), (Object)Matchers.startsWith((String)"com.atlassian.upm.core.log.PluginInstallerPluginLogAccessorImpl"), (Object)Matchers.startsWith((String)"com.atlassian.upm.log.PluginSettingsAuditLogService"), (Object)Matchers.startsWith((String)"com.atlassian.restricted.instance.cipher"), (Object)Matchers.startsWith((String)"com.atlassian.analytics.client"));

    @Override
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        if (!this.isStateMutationAllowedInCurrentRequest() && XsrfUtils.areMutativeGetsForbiddenByConfig() && !this.isEntityMutationAllowed(entity, currentState, previousState, propertyNames) && !ReadOnlyGetMethodEnforcer.isAutomatedPasswordConversion(entity, currentState, previousState, propertyNames)) {
            this.log.error((Object)"Entity mutation is not allowed");
            this.fail(entity, currentState, previousState);
        }
        return super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
    }

    @Override
    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        if (!this.isEntityCreationAllowed(entity, state, propertyNames)) {
            this.failIfStateMutationNotAllowed(entity, state);
        }
        return super.onSave(entity, id, state, propertyNames, types);
    }

    @Override
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        this.failIfDeletionNotAllowed(entity, state);
        super.onDelete(entity, id, state, propertyNames, types);
    }

    private void failIfStateMutationNotAllowed(Object entity, Object[] state) {
        if (!this.isStateMutationAllowedInCurrentRequest() && !this.isMutationAllowedToOccurInAnyRequest(entity) && XsrfUtils.areMutativeGetsForbiddenByConfig()) {
            this.log.error((Object)"State mutation is not allowed");
            this.fail(entity, state, null);
        }
    }

    private void failIfDeletionNotAllowed(Object entity, Object[] state) {
        if (!this.isStateMutationAllowedInCurrentRequest() && !this.isMutationAllowedToOccurInAnyRequest(entity) && XsrfUtils.areMutativeGetsForbiddenByConfig() && !this.isEntityDeletionAllowed(entity)) {
            this.log.error((Object)"Deletion is not allowed");
            this.fail(entity, state, null);
        }
    }

    private void fail(Object entity, Object[] currentState, @Nullable Object[] previousState) {
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        String url = request.getRequestURL().toString();
        String query = request.getQueryString();
        String states = "[" + Arrays.toString(previousState) + "]->\n->[" + Arrays.toString(currentState) + "]\n";
        Object id = "";
        if (entity instanceof BambooIdProvider) {
            id = "(id=" + ((BambooIdProvider)entity).getId() + ")";
        }
        XsrfUtils.fail((String)("A mutative operation was attempted on " + entity.getClass().getSimpleName() + (String)id + " within a non-mutative HTTP request: " + url + (String)(query != null ? "?" + query : "") + " : " + states));
    }

    private boolean isStateMutationAllowedInCurrentRequest() {
        return XsrfUtils.noRequestOrRequestCanMutateState() || this.isRequestExplicitlyAllowedToMutateState(RequestCacheThreadLocal.getNonNullRequest());
    }

    private boolean isMutationAllowedToOccurInAnyRequest(Object entity) {
        if (entity instanceof BandanaItem) {
            String key = ((BandanaItem)entity).getKey();
            return CoreMatchers.anyOf(BANDANA_KEY_WHITELIST).matches((Object)key);
        }
        return false;
    }

    @VisibleForTesting
    boolean isRequestExplicitlyAllowedToMutateState(HttpServletRequest request) {
        return XSRF_HEADER_VALIDATOR.requestHasValidXsrfHeader(request) || CoreMatchers.anyOf(XSRF_WHITELIST).matches((Object)request);
    }

    @VisibleForTesting
    static boolean isAutomatedPasswordConversion(Object entity, Object[] currentStates, Object[] previousStates, String[] propertyNames) {
        if (!(entity instanceof DefaultHibernateUser) || previousStates == null) {
            return false;
        }
        for (int i = 0; i < previousStates.length; ++i) {
            Object previousState = previousStates[i];
            Object currentState = currentStates[i];
            if (Objects.equal((Object)previousState, (Object)currentState)) continue;
            boolean isPasswordChange = propertyNames[i].equals("password");
            if (isPasswordChange) {
                String previousPassword = (String)previousState;
                String currentPassword = (String)currentState;
                String newFormatId = "{PKCS5S2}";
                if (!StringUtils.contains((CharSequence)previousPassword, (CharSequence)"{PKCS5S2}") && StringUtils.contains((CharSequence)currentPassword, (CharSequence)"{PKCS5S2}")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean isEntityCreationAllowed(Object entity, Object[] state, String[] propertyNames) {
        if (entity instanceof InternalUserAttribute) {
            Object value = this.getInternalUserAttributeName(state, propertyNames);
            return value.equals("lastAuthenticated") || value.equals("requiresPasswordChange") || value.equals("invalidPasswordAttempts") || value.equals(AUTO_GROUPS_ADDED);
        }
        return entity instanceof DefaultHibernateExternalEntity || entity instanceof LoginInformationImpl || entity instanceof InternalDirectoryEntity || entity instanceof InternalMembership || entity instanceof UserMembershipTombstone;
    }

    @VisibleForTesting
    boolean isEntityDeletionAllowed(Object entity) {
        if (entity instanceof BandanaItem) {
            return CoreMatchers.anyOf(BANDANA_KEY_WHITELIST).matches((Object)((BandanaItem)entity).getKey());
        }
        return entity instanceof InternalMembership;
    }

    private boolean isInternalUserAttributeWhitelisted(Object attribute) {
        return attribute.equals("lastAuthenticated") || attribute.equals("requiresPasswordChange") || attribute.equals("invalidPasswordAttempts") || attribute.equals(AUTO_GROUPS_ADDED);
    }

    private boolean isEntityMutationAllowed(Object entity, Object[] currentState, Object[] previousState, String[] propertyNames) {
        if (entity instanceof LoginInformationImpl) {
            return true;
        }
        if (entity instanceof InternalUser) {
            Map propertyChanges = BambooHibernateUtils.getPropertyChanges((Object[])currentState, (Object[])previousState, (String[])propertyNames);
            if (propertyChanges.size() == 1 && propertyChanges.containsKey("updatedDate")) {
                return true;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)BambooHibernateUtils.describePropertyChanges((Map)propertyChanges));
            }
            return true;
        }
        if (entity instanceof InternalUserAttribute) {
            Object oldValue = this.getInternalUserAttributeName(previousState, propertyNames);
            Object newValue = this.getInternalUserAttributeName(currentState, propertyNames);
            return newValue != null && newValue.equals(oldValue) && this.isInternalUserAttributeWhitelisted(oldValue);
        }
        if (entity instanceof BandanaItem) {
            return CoreMatchers.anyOf(BANDANA_KEY_WHITELIST).matches((Object)((BandanaItem)entity).getKey());
        }
        return false;
    }

    private Object getInternalUserAttributeName(Object[] previousState, String[] propertyNames) {
        return BambooHibernateUtils.getPropertyByName((String)"name", (String[])propertyNames, (Object[])previousState);
    }
}

