/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

class AfterCommitHandlerTxSync
extends TransactionSynchronizationAdapter {
    private static final Logger log = Logger.getLogger(AfterCommitHandlerTxSync.class);
    private final Map<Class<? extends AfterCommitHandler>, AfterCommitHandler> afterCommitHandlers = new HashMap<Class<? extends AfterCommitHandler>, AfterCommitHandler>(2);
    private int counter = 0;

    AfterCommitHandlerTxSync() {
    }

    public void afterCompletion(int status) {
        this.afterCommitHandlers.clear();
    }

    public void afterCommit() {
        if (++this.counter >= 2) {
            log.fatal((Object)"After commit triggered more than once");
        }
        this.afterCommitHandlers.values().forEach(AfterCommitHandler::afterCommit);
        this.afterCommitHandlers.clear();
    }

    public <T extends AfterCommitHandler> T getAfterCommitHandler(Class<T> afterCommitHandlerClass, Supplier<T> afterCommitHandlerFactory) {
        AfterCommitHandler existingAfterCommitHandler = this.afterCommitHandlers.get(afterCommitHandlerClass);
        if (existingAfterCommitHandler != null) {
            return (T)existingAfterCommitHandler;
        }
        AfterCommitHandler newAfterCommitHandler = (AfterCommitHandler)afterCommitHandlerFactory.get();
        this.afterCommitHandlers.put(afterCommitHandlerClass, newAfterCommitHandler);
        return (T)newAfterCommitHandler;
    }
}

