/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.cluster.CrossNodesRemoteBroadcasterImpl;
import com.atlassian.bamboo.cluster.event.CrossNodesEvent;
import com.atlassian.bamboo.cluster.event.bamboo.plan.InvalidateBuildNumbersRangeEvent;
import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class BuildNumbersRangeSynchronisation
implements AfterCommitHandler {
    private static final Logger log = LogManager.getLogger(BuildNumbersRangeSynchronisation.class);
    private final Map<PlanKey, Integer> saved = new HashMap<PlanKey, Integer>();
    private final Map<PlanKey, Integer> deleted = new HashMap<PlanKey, Integer>();

    BuildNumbersRangeSynchronisation() {
    }

    @Override
    public void afterCommit() {
        if (!ContainerManager.isContainerSetup()) {
            return;
        }
        ImmutablePlanCacheService immutablePlanCacheService = (ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get();
        ImmutableList.Builder savedEntriesToBeSent = ImmutableList.builder();
        ImmutableList.Builder deletedEntriesToBeSent = ImmutableList.builder();
        for (Map.Entry<PlanKey, Integer> entry : this.saved.entrySet()) {
            immutablePlanCacheService.invalidateBuildNumbersRange(entry.getKey(), entry.getValue().intValue(), true);
            savedEntriesToBeSent.add((Object)InvalidateBuildNumbersRangeEvent.InvalidateBuildNumbersRangeEntry.of((PlanKey)entry.getKey(), (int)entry.getValue()));
        }
        for (Map.Entry<PlanKey, Integer> entry : this.deleted.entrySet()) {
            immutablePlanCacheService.invalidateBuildNumbersRange(entry.getKey(), entry.getValue().intValue(), false);
            deletedEntriesToBeSent.add((Object)InvalidateBuildNumbersRangeEvent.InvalidateBuildNumbersRangeEntry.of((PlanKey)entry.getKey(), (int)entry.getValue()));
        }
        CrossNodesRemoteBroadcasterImpl.getComponentAccessor().ifPresentOrElse(c -> c.send((CrossNodesEvent)InvalidateBuildNumbersRangeEvent.builder().setSavedEntries((List)savedEntriesToBeSent.build()).setDeletedEntries((List)deletedEntriesToBeSent.build()).build()), () -> log.debug((Object)"Cross-node broadcaster not defined. Event cannot be sent to other nodes"));
    }

    public void scheduleSave(ResultsSummary resultSummary) {
        if (!this.saved.containsKey(resultSummary.getPlanKey()) || resultSummary.getBuildNumber() > this.saved.get(resultSummary.getPlanKey())) {
            this.saved.put(resultSummary.getPlanKey(), resultSummary.getBuildNumber());
        }
    }

    public void scheduleDeletion(ResultsSummary resultSummary) {
        if (!this.deleted.containsKey(resultSummary.getPlanKey()) || resultSummary.getBuildNumber() < this.deleted.get(resultSummary.getPlanKey())) {
            this.deleted.put(resultSummary.getPlanKey(), resultSummary.getBuildNumber());
        }
    }
}

