/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.deployments.cache.LinkedDeploymentProjectCacheService;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.spring.container.ContainerManager;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

class DeploymentCacheSynchronisation
implements AfterCommitHandler {
    private static final Logger log = Logger.getLogger(DeploymentCacheSynchronisation.class);
    private final Collection<Long> toDelete = new HashSet<Long>();
    private final Collection<InternalDeploymentProject> toRefresh = new HashSet<InternalDeploymentProject>();

    DeploymentCacheSynchronisation() {
    }

    public boolean scheduleDeletion(long deploymentProjectId) {
        return this.toDelete.add(deploymentProjectId);
    }

    public boolean scheduleRefresh(InternalDeploymentProject deploymentProject) {
        return this.toRefresh.add(deploymentProject);
    }

    @Override
    public void afterCommit() {
        if (!ContainerManager.isContainerSetup()) {
            return;
        }
        LinkedDeploymentProjectCacheService linkedDeploymentProjectCacheService = (LinkedDeploymentProjectCacheService)ComponentAccessor.LINKED_DEPLOYMENT_PROJECT_CACHE_SERVICE.get();
        log.debug((Object)"afterCommit");
        for (InternalDeploymentProject deploymentProject : this.toRefresh) {
            log.debug((Object)("refreshing deployment cache entry for " + deploymentProject.getId()));
            linkedDeploymentProjectCacheService.refresh(deploymentProject);
        }
        for (Long deploymentProjectId : this.toDelete) {
            log.debug((Object)("removed from the deployment cache: " + deploymentProjectId));
            linkedDeploymentProjectCacheService.invalidate(deploymentProjectId.longValue());
        }
        log.debug((Object)"/afterCommit");
    }
}

