/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.deployments.projects.InternalDeploymentProject;
import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandlerTxSync;
import com.atlassian.bamboo.hibernate.cachehooks.BuildNumbersRangeSynchronisation;
import com.atlassian.bamboo.hibernate.cachehooks.CommentCacheSynchronisation;
import com.atlassian.bamboo.hibernate.cachehooks.DeploymentCacheSynchronisation;
import com.atlassian.bamboo.hibernate.cachehooks.LatestResultSummarySynchronisation;
import com.atlassian.bamboo.hibernate.cachehooks.PlanCacheSynchronisation;
import com.atlassian.bamboo.hibernate.cachehooks.RepositoryDataEntityCacheSynchronisation;
import com.atlassian.bamboo.hibernate.cachehooks.VcsBambooSpecsSourceSynchronisation;
import com.atlassian.bamboo.hibernate.invalidators.CacheInvalidators;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSource;
import com.atlassian.bamboo.repository.RepositoryDataEntityImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.OptionalNarrow;
import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.CallbackException;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate.support.ChainedInterceptorSupport;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DirtiedHibernateSessionObjectRecorder
extends ChainedInterceptorSupport {
    private static final Logger log = LogManager.getLogger(DirtiedHibernateSessionObjectRecorder.class);

    @Override
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        if (log.isTraceEnabled() && entity instanceof BuildResultsSummaryImpl) {
            Map propertyChanges = BambooHibernateUtils.getPropertyChanges((Object[])currentState, (Object[])previousState, (String[])propertyNames);
            log.trace("BRS change: {}", (Object)BambooHibernateUtils.describePropertyChanges((Map)propertyChanges));
        }
        boolean rc = super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        this.scheduleInvalidationIfNeeded("flush dirty", entity);
        return rc;
    }

    @Override
    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        boolean result = super.onSave(entity, id, state, propertyNames, types);
        this.scheduleInvalidationIfNeeded("save", entity);
        this.scheduleIndexingIfNeeded(entity);
        return result;
    }

    @Override
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        super.onDelete(entity, id, state, propertyNames, types);
        this.scheduleDeletionIfNeeded("delete", entity);
    }

    private void scheduleIndexingIfNeeded(Object entity) {
        ImmutablePlanCacheService immutablePlanCacheService = (ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get();
        if (!immutablePlanCacheService.isCacheEnabled()) {
            log.debug("Cache is disabled");
            return;
        }
        AfterCommitHandlerTxSync txSync = DirtiedHibernateSessionObjectRecorder.getTxSync();
        CacheInvalidators.forEntity(entity).ifPresent(invalidator -> {
            boolean wasScheduled = txSync.getAfterCommitHandler(PlanCacheSynchronisation.class, PlanCacheSynchronisation::new).scheduleIndexing(entity);
            if (wasScheduled) {
                log.debug("scheduling indexing in cache: " + invalidator);
            }
        });
    }

    private void scheduleInvalidationIfNeeded(String reason, Object entity) {
        ResultsSummary resultSummary;
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            log.warn("Transaction synchronisation manager is not active");
            return;
        }
        ImmutablePlanCacheService immutablePlanCacheService = (ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get();
        if (!immutablePlanCacheService.isCacheEnabled()) {
            log.debug("Cache is disabled");
            return;
        }
        AfterCommitHandlerTxSync txSync = DirtiedHibernateSessionObjectRecorder.getTxSync();
        CacheInvalidators.forEntity(entity).ifPresent(invalidator -> {
            boolean wasScheduled = txSync.getAfterCommitHandler(PlanCacheSynchronisation.class, PlanCacheSynchronisation::new).scheduleInvalidation((ImmutablePlanCacheService.CacheInvalidator)invalidator);
            if (wasScheduled) {
                log.debug("{}, scheduling cascaded invalidation in cache: {}", (Object)reason, invalidator);
            }
        });
        InternalDeploymentProject deploymentProject = (InternalDeploymentProject)Narrow.downTo((Object)entity, InternalDeploymentProject.class);
        if (deploymentProject != null) {
            txSync.getAfterCommitHandler(DeploymentCacheSynchronisation.class, DeploymentCacheSynchronisation::new).scheduleRefresh(deploymentProject);
        }
        if ((resultSummary = (ResultsSummary)Narrow.downTo((Object)entity, ResultsSummary.class)) != null) {
            txSync.getAfterCommitHandler(BuildNumbersRangeSynchronisation.class, BuildNumbersRangeSynchronisation::new).scheduleSave(resultSummary);
            txSync.getAfterCommitHandler(LatestResultSummarySynchronisation.class, LatestResultSummarySynchronisation::new).invalidate((ImmutableResultsSummary)resultSummary);
        }
        OptionalNarrow.downTo((Object)entity, Comment.class).ifPresent(comment -> txSync.getAfterCommitHandler(CommentCacheSynchronisation.class, CommentCacheSynchronisation::new).invalidate(comment.getEntityId()));
        OptionalNarrow.downTo((Object)entity, RepositoryDataEntityImpl.class).ifPresent(repositoryDataEntity -> txSync.getAfterCommitHandler(RepositoryDataEntityCacheSynchronisation.class, RepositoryDataEntityCacheSynchronisation::new).invalidate(repositoryDataEntity.getId()));
        OptionalNarrow.downTo((Object)entity, PlanVcsBambooSpecsSource.class).ifPresent(specsSource -> txSync.getAfterCommitHandler(VcsBambooSpecsSourceSynchronisation.class, VcsBambooSpecsSourceSynchronisation::new).invalidate((PlanVcsBambooSpecsSource)specsSource));
    }

    private void scheduleDeletionIfNeeded(String reason, Object entity) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            log.warn("Transaction synchronisation manager is not active");
            return;
        }
        this.scheduleInvalidationIfNeeded(reason, entity);
        AfterCommitHandlerTxSync txSync = DirtiedHibernateSessionObjectRecorder.getTxSync();
        OptionalNarrow.downTo((Object)entity, ImmutablePlan.class).ifPresent(plan -> {
            boolean wasScheduled = txSync.getAfterCommitHandler(PlanCacheSynchronisation.class, PlanCacheSynchronisation::new).scheduleDeletion(plan.getPlanKey());
            if (wasScheduled) {
                log.debug("{}, scheduling deletion from cache: {}", (Object)reason, (Object)plan.getPlanKey());
            }
        });
        OptionalNarrow.downTo((Object)entity, ImmutableChainStage.class).ifPresent(stage -> {
            boolean wasScheduled = txSync.getAfterCommitHandler(PlanCacheSynchronisation.class, PlanCacheSynchronisation::new).scheduleDeletion(stage.getId());
            if (wasScheduled) {
                log.debug("{}, scheduling stage deletion from cache: {}", (Object)reason, (Object)stage.getId());
            }
        });
        OptionalNarrow.downTo((Object)entity, InternalDeploymentProject.class).ifPresent(deploymentProject -> txSync.getAfterCommitHandler(DeploymentCacheSynchronisation.class, DeploymentCacheSynchronisation::new).scheduleDeletion(deploymentProject.getId()));
        OptionalNarrow.downTo((Object)entity, ResultsSummary.class).ifPresent(resultSummary -> {
            txSync.getAfterCommitHandler(BuildNumbersRangeSynchronisation.class, BuildNumbersRangeSynchronisation::new).scheduleDeletion((ResultsSummary)resultSummary);
            txSync.getAfterCommitHandler(LatestResultSummarySynchronisation.class, LatestResultSummarySynchronisation::new).invalidate((ImmutableResultsSummary)resultSummary);
        });
        OptionalNarrow.downTo((Object)entity, Comment.class).ifPresent(comment -> txSync.getAfterCommitHandler(CommentCacheSynchronisation.class, CommentCacheSynchronisation::new).invalidate(comment.getEntityId()));
        OptionalNarrow.downTo((Object)entity, PlanVcsBambooSpecsSource.class).ifPresent(specsSource -> txSync.getAfterCommitHandler(VcsBambooSpecsSourceSynchronisation.class, VcsBambooSpecsSourceSynchronisation::new).onDelete((PlanVcsBambooSpecsSource)specsSource));
        OptionalNarrow.downTo((Object)entity, RepositoryDataEntityImpl.class).ifPresent(repositoryDataEntity -> txSync.getAfterCommitHandler(RepositoryDataEntityCacheSynchronisation.class, RepositoryDataEntityCacheSynchronisation::new).scheduleDeletion(repositoryDataEntity.getId()));
    }

    private static AfterCommitHandlerTxSync getTxSync() {
        for (TransactionSynchronization txSync : TransactionSynchronizationManager.getSynchronizations()) {
            AfterCommitHandlerTxSync cacheSynchronization = (AfterCommitHandlerTxSync)((Object)Narrow.downTo((Object)txSync, AfterCommitHandlerTxSync.class));
            if (cacheSynchronization == null) continue;
            return cacheSynchronization;
        }
        AfterCommitHandlerTxSync cacheSynchronization = new AfterCommitHandlerTxSync();
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)cacheSynchronization);
        return cacheSynchronization;
    }
}

