/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.cluster.CrossNodesRemoteBroadcasterImpl;
import com.atlassian.bamboo.cluster.event.CrossNodesEvent;
import com.atlassian.bamboo.cluster.event.bamboo.plan.InvalidateLatestResultSummaryEvent;
import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.spring.container.ContainerManager;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class LatestResultSummarySynchronisation
implements AfterCommitHandler {
    private static final Logger log = LogManager.getLogger(LatestResultSummarySynchronisation.class);
    private final Map<PlanKey, Pair<PlanResultKey, Boolean>> latestChangedResultSummary = new HashMap<PlanKey, Pair<PlanResultKey, Boolean>>();

    LatestResultSummarySynchronisation() {
    }

    @Override
    public void afterCommit() {
        if (!ContainerManager.isContainerSetup()) {
            return;
        }
        ImmutablePlanCacheService immutablePlanCacheService = (ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get();
        this.latestChangedResultSummary.values().forEach(p -> immutablePlanCacheService.invalidateLatestResultSummary((PlanResultKey)p.getFirst(), ((Boolean)p.getSecond()).booleanValue()));
        CrossNodesRemoteBroadcasterImpl.getComponentAccessor().ifPresentOrElse(c -> c.send((CrossNodesEvent)InvalidateLatestResultSummaryEvent.builder().setEntities(this.latestChangedResultSummary.values().stream().map(p -> InvalidateLatestResultSummaryEvent.InvalidateLatestResultSummaryEntry.of((PlanResultKey)((PlanResultKey)p.getFirst()), (boolean)((Boolean)p.getSecond()))).collect(Collectors.toList())).build()), () -> log.debug((Object)"Cross-node broadcaster not defined. Event cannot be sent to other nodes"));
    }

    public void invalidate(ImmutableResultsSummary resultSummary) {
        Pair<PlanResultKey, Boolean> latestResultSummary = this.latestChangedResultSummary.get(resultSummary.getPlanKey());
        if (latestResultSummary == null || resultSummary.getBuildNumber() > ((PlanResultKey)latestResultSummary.getFirst()).getBuildNumber()) {
            boolean shouldResetAverages = latestResultSummary != null && (Boolean)latestResultSummary.getSecond() != false;
            this.latestChangedResultSummary.put(resultSummary.getPlanKey(), (Pair<PlanResultKey, Boolean>)Pair.make((Object)resultSummary.getPlanResultKey(), (Object)(shouldResetAverages || LifeCycleState.isFinalized((LifeCycleState)resultSummary.getLifeCycleState()) ? 1 : 0)));
        }
    }
}

