/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.cluster.CrossNodesRemoteBroadcasterImpl;
import com.atlassian.bamboo.cluster.event.CrossNodesEvent;
import com.atlassian.bamboo.cluster.event.bamboo.plan.InvalidatePlanCacheEvent;
import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.spring.container.ContainerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

class PlanCacheSynchronisation
implements AfterCommitHandler {
    private static final Logger log = Logger.getLogger(PlanCacheSynchronisation.class);
    private final Collection<PlanKey> toDelete = new HashSet<PlanKey>();
    private final Collection<Long> stagesToDelete = new HashSet<Long>();
    private final Collection<ImmutableChain> toIndex = new HashSet<ImmutableChain>();
    private final Collection<ImmutablePlanCacheService.CacheInvalidator> invalidators = new HashSet<ImmutablePlanCacheService.CacheInvalidator>();

    PlanCacheSynchronisation() {
    }

    public boolean scheduleDeletion(PlanKey planKey) {
        return this.toDelete.add(planKey);
    }

    public boolean scheduleDeletion(Long stageId) {
        return this.stagesToDelete.add(stageId);
    }

    public boolean scheduleInvalidation(ImmutablePlanCacheService.CacheInvalidator invalidator) {
        return this.invalidators.add(invalidator);
    }

    public boolean scheduleIndexing(Object entity) {
        ImmutableChain immutableChain = (ImmutableChain)Narrow.downTo((Object)entity, ImmutableChain.class);
        if (immutableChain == null) {
            return false;
        }
        return this.toIndex.add(immutableChain);
    }

    @Override
    public void afterCommit() {
        if (!ContainerManager.isContainerSetup()) {
            return;
        }
        ImmutablePlanCacheService immutablePlanCacheService = (ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get();
        log.debug((Object)"afterCommit");
        if (!immutablePlanCacheService.isCacheEnabled()) {
            return;
        }
        this.toIndex.forEach(arg_0 -> ((ImmutablePlanCacheService)immutablePlanCacheService).indexPlan(arg_0));
        List toIndexPlanKeys = this.toIndex.stream().map(PlanIdentifier::getPlanKey).collect(Collectors.toList());
        for (PlanKey planKey2 : this.toDelete) {
            log.debug((Object)("removed from the plan cache: " + planKey2));
            immutablePlanCacheService.remove(planKey2);
        }
        for (Long stageId : this.stagesToDelete) {
            log.debug((Object)("stage removed from the plan cache: " + stageId));
            immutablePlanCacheService.onStageDeleted(stageId.longValue());
        }
        HashSet chainsToInvalidate = new HashSet();
        HashSet chainsToReindex = new HashSet();
        for (ImmutablePlanCacheService.CacheInvalidator invalidator : this.invalidators) {
            log.debug((Object)("Running invalidator: " + invalidator.getDescription()));
            immutablePlanCacheService.getChainsToInvalidateAndReindex(invalidator, chainsToInvalidate, chainsToReindex);
        }
        chainsToInvalidate.forEach(arg_0 -> ((ImmutablePlanCacheService)immutablePlanCacheService).cascadeInvalidate(arg_0));
        chainsToReindex.forEach(planKey -> {
            ImmutableChain chain = immutablePlanCacheService.getImmutablePlanByKey(planKey);
            if (chain != null) {
                immutablePlanCacheService.indexPlan(chain);
            }
        });
        CrossNodesRemoteBroadcasterImpl.getComponentAccessor().ifPresentOrElse(c -> c.send((CrossNodesEvent)InvalidatePlanCacheEvent.builder().chainsToIndex(toIndexPlanKeys).chainsToDelete(new ArrayList<PlanKey>(this.toDelete)).stagesToDelete(new ArrayList<Long>(this.stagesToDelete)).chainsToInvalidate(new ArrayList(chainsToInvalidate)).chainsToReindex(new ArrayList(chainsToReindex)).build()), () -> log.debug((Object)"Cross-node broadcaster not defined. Event cannot be sent to other nodes"));
        log.debug((Object)"/afterCommit");
    }
}

