/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import com.atlassian.bamboo.repository.CachedRepositoryDefinitionUtils;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.fugue.Checked;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;

public class RepositoryDataEntityCacheSynchronisation
implements AfterCommitHandler {
    private static final Supplier<CachedRepositoryDefinitionUtils> CACHED_REPOSITORY_DEFINITION_UTILS = ComponentAccessor.newLazyComponentReference((String)"cachedRepositoryDefinitionUtils");
    private final Set<Long> entitiesToInvalidate = new HashSet<Long>();
    private final Set<Long> entitiesToDelete = new HashSet<Long>();

    @Override
    public void afterCommit() {
        if (!ContainerManager.isContainerSetup()) {
            return;
        }
        Checked.now(() -> CACHED_REPOSITORY_DEFINITION_UTILS.get()).toOptional().ifPresent(service -> service.deleteAndInvalidate(this.entitiesToDelete, this.entitiesToInvalidate));
    }

    public void invalidate(long entityId) {
        this.entitiesToInvalidate.add(entityId);
    }

    public void scheduleDeletion(long entityId) {
        this.entitiesToDelete.add(entityId);
    }
}

