/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.cachehooks;

import com.atlassian.bamboo.cluster.CrossNodesRemoteBroadcasterImpl;
import com.atlassian.bamboo.cluster.event.CrossNodesEvent;
import com.atlassian.bamboo.cluster.event.bamboo.plan.InvalidateSpecsStateForPlanRequestEvent;
import com.atlassian.bamboo.hibernate.cachehooks.AfterCommitHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.rss.PlanVcsBambooSpecsSource;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.spring.container.ContainerManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class VcsBambooSpecsSourceSynchronisation
implements AfterCommitHandler {
    private static final Logger log = LogManager.getLogger(VcsBambooSpecsSourceSynchronisation.class);
    private final Set<PlanKey> planKeysToInvalidate = new HashSet<PlanKey>();
    private final Set<PlanKey> keysOfPlansDetachedFromRss = new HashSet<PlanKey>();

    VcsBambooSpecsSourceSynchronisation() {
    }

    @Override
    public void afterCommit() {
        if (!ContainerManager.isContainerSetup()) {
            return;
        }
        ImmutablePlanCacheService immutablePlanCacheService = (ImmutablePlanCacheService)ComponentAccessor.IMMUTABLE_PLAN_CACHE_SERVICE.get();
        this.planKeysToInvalidate.forEach(arg_0 -> ((ImmutablePlanCacheService)immutablePlanCacheService).invalidateSpecsStateForPlan(arg_0));
        this.keysOfPlansDetachedFromRss.forEach(arg_0 -> ((ImmutablePlanCacheService)immutablePlanCacheService).invalidateSpecsStateForPlan(arg_0));
        CrossNodesRemoteBroadcasterImpl.getComponentAccessor().ifPresentOrElse(c -> c.send((CrossNodesEvent)InvalidateSpecsStateForPlanRequestEvent.builder().planKeysToInvalidate(new ArrayList<PlanKey>(this.planKeysToInvalidate)).keysOfPlansDetachedFromRss(new ArrayList<PlanKey>(this.keysOfPlansDetachedFromRss)).build()), () -> log.debug((Object)"Cross-node broadcaster not defined. Event cannot be sent to other nodes"));
    }

    public void invalidate(PlanVcsBambooSpecsSource planVcsBambooSpecsSource) {
        this.planKeysToInvalidate.add(planVcsBambooSpecsSource.getPlan().getPlanKey());
    }

    public void onDelete(PlanVcsBambooSpecsSource planVcsBambooSpecsSource) {
        this.keysOfPlansDetachedFromRss.add(planVcsBambooSpecsSource.getPlan().getPlanKey());
    }
}

