/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.callbacks;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;

public class BulkUpdate
implements HibernateCallback<Integer> {
    private final String queryName;
    private final String queryString;
    private final Map<String, Object> parameters;

    private BulkUpdate(String queryName, String queryString, Object ... parameters) {
        this.queryName = queryName;
        this.queryString = queryString;
        this.parameters = new HashMap<String, Object>();
        if (parameters != null) {
            Preconditions.checkArgument((parameters.length % 2 == 0 ? 1 : 0) != 0, (Object)"Expecting name-value pairs as arguments");
            for (int i = 0; i < parameters.length; i += 2) {
                Preconditions.checkArgument((boolean)(parameters[i] instanceof String), (Object)"Expecting name-value pairs as arguments");
                this.parameters.put((String)parameters[i], parameters[i + 1]);
            }
        }
    }

    public Integer doInHibernate(Session session) throws HibernateException {
        Query queryObject = this.queryName != null ? session.getNamedQuery(this.queryName) : session.createQuery(this.queryString);
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            queryObject.setParameter(entry.getKey(), entry.getValue());
        }
        return queryObject.executeUpdate();
    }

    public static BulkUpdate forQuery(String queryString, Object ... parameters) {
        return new BulkUpdate(null, queryString, parameters);
    }

    public static BulkUpdate forNamedQuery(String queryName, Object ... parameters) {
        return new BulkUpdate(queryName, null, parameters);
    }
}

