/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.callbacks;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public abstract class IteratorHibernateCallback<T>
implements HibernateCallback<Integer> {
    private static final Logger log = Logger.getLogger(IteratorHibernateCallback.class);
    private final int fetchSize;

    protected IteratorHibernateCallback(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public Integer doInHibernate(Session session) throws HibernateException {
        int count = 0;
        if (session != null) {
            Iterator iterator = this.configureQuery(session).setFetchSize(this.fetchSize).iterate();
            while (iterator.hasNext()) {
                this.nextResultItem(session, iterator.next(), ++count);
            }
        }
        return count;
    }

    @NotNull
    public abstract Query configureQuery(@NotNull Session var1) throws HibernateException;

    public abstract void nextResultItem(@NotNull Session var1, @NotNull T var2, int var3) throws HibernateException;
}

