/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.callbacks;

import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateCallback;

public abstract class ScrollHibernateCallback
implements HibernateCallback<Long> {
    private static final Logger log = Logger.getLogger(ScrollHibernateCallback.class);
    public static final int DEFAULT_FETCH_SIZE = 1000;
    private final int fetchSize;
    private final ScrollMode scrollMode;

    public ScrollHibernateCallback(int fetchSize, ScrollMode scrollMode) {
        this.fetchSize = fetchSize;
        this.scrollMode = scrollMode;
    }

    public ScrollHibernateCallback() {
        this(1000, ScrollMode.FORWARD_ONLY);
    }

    public Long doInHibernate(Session session) throws HibernateException {
        long count = 0L;
        if (session != null) {
            try (ScrollableResults data = this.configureQuery(session).setFetchSize(this.fetchSize).scroll(this.scrollMode);){
                while (data.next()) {
                    this.nextScrollableResult(session, data);
                    ++count;
                }
            }
        }
        return count;
    }

    @NotNull
    public abstract Query configureQuery(@NotNull Session var1) throws HibernateException;

    public abstract void nextScrollableResult(@NotNull Session var1, @NotNull ScrollableResults var2) throws HibernateException;
}

