/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.invalidators;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.google.common.cache.Cache;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class AbstractCacheInvalidator
implements ImmutablePlanCacheService.CacheInvalidator {
    private final String description;
    private boolean shouldReindex;
    private boolean shouldInvalidate = true;

    protected AbstractCacheInvalidator(@NotNull String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void getChainsToInvalidateAndReindex(@NotNull ImmutablePlanCacheService immutablePlanCacheService, @NotNull Cache<PlanKey, ImmutableChain> planKeyChainMap, @NotNull PlanCacheIndices planCacheIndices, @NotNull Set<PlanKey> chainsToInvalidate, @NotNull Set<PlanKey> chainsToReindex) {
        Set<PlanKey> affectedPlanKeys = this.getAffectedPlanKeys(planKeyChainMap, planCacheIndices);
        if (this.shouldInvalidate) {
            chainsToInvalidate.addAll(affectedPlanKeys);
        }
        if (this.shouldReindex) {
            chainsToReindex.addAll(affectedPlanKeys);
        }
    }

    AbstractCacheInvalidator withReindex() {
        this.shouldReindex = true;
        return this;
    }

    AbstractCacheInvalidator withoutInvalidate() {
        this.shouldInvalidate = false;
        return this;
    }

    protected abstract Set<PlanKey> getAffectedPlanKeys(@NotNull Cache<PlanKey, ImmutableChain> var1, @NotNull PlanCacheIndices var2);
}

