/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.invalidators;

import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.google.common.cache.Cache;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildDefinitionInvalidator
implements ImmutablePlanCacheService.CacheInvalidator {
    private static final Logger log = Logger.getLogger(BuildDefinitionInvalidator.class);
    private final Long jobId;
    private final Long chainId;
    private final PlanKey planKey;

    BuildDefinitionInvalidator(@NotNull Object entity) {
        this((DefaultBuildDefinitionForBuild)entity);
    }

    private BuildDefinitionInvalidator(DefaultBuildDefinitionForBuild buildDefinition) {
        this.planKey = buildDefinition.getPlan().getPlanKey();
        Plan plan = buildDefinition.getPlan();
        if (plan instanceof ImmutableChain) {
            this.chainId = plan.getId();
            this.jobId = null;
        } else {
            this.chainId = null;
            this.jobId = plan.getId();
        }
    }

    public String getDescription() {
        return "buildDefinition of " + this.planKey;
    }

    public void getChainsToInvalidateAndReindex(@NotNull ImmutablePlanCacheService immutablePlanCacheService, @NotNull Cache<PlanKey, ImmutableChain> planKeyChainMap, @NotNull PlanCacheIndices planCacheIndices, @NotNull Set<PlanKey> chainsToInvalidate, @NotNull Set<PlanKey> chainsToReindex) {
        PlanKey chainKey;
        PlanKey planKey = chainKey = this.chainId != null ? planCacheIndices.getPlanIdIndexer().getChain(this.chainId.longValue()) : planCacheIndices.getPlanIdIndexer().getChainOfJob(this.jobId.longValue());
        if (chainKey != null) {
            chainsToInvalidate.add(chainKey);
        }
    }
}

