/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.invalidators;

import com.atlassian.bamboo.hibernate.invalidators.AbstractCacheInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.ByChainKeyCacheInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.CacheInvalidators;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.google.common.cache.Cache;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ByKeyInvalidators {
    private static final ImmutablePlanCacheService.CacheInvalidator NO_OP_INVALIDATOR = new AbstractCacheInvalidator("noop"){

        @Override
        @NotNull
        protected Set<PlanKey> getAffectedPlanKeys(@NotNull Cache<PlanKey, ImmutableChain> planKeyChainMap, @NotNull PlanCacheIndices planCacheIndices) {
            return Collections.emptySet();
        }
    };

    private ByKeyInvalidators() {
    }

    public static Pair<Class<?>, CacheInvalidators.InvalidatorFactory> newArtifactDefinitionInvalidator(Class<ArtifactDefinition> clazz) {
        return Pair.pair(clazz, o -> {
            ArtifactDefinition artifactDefinition = (ArtifactDefinition)clazz.cast(o);
            String description = "artifact[" + artifactDefinition.getName() + "]";
            PlanKey chainKey = artifactDefinition.getProducerJob().getParent().getPlanKey();
            return new ByChainKeyCacheInvalidator(description, chainKey);
        });
    }

    public static Pair<Class<?>, CacheInvalidators.InvalidatorFactory> newArtifactSubscriptionInvalidator(Class<ArtifactSubscription> clazz) {
        return Pair.pair(clazz, o -> {
            ArtifactSubscription artifactSubscription = (ArtifactSubscription)clazz.cast(o);
            String description = "artifact[" + artifactSubscription.getName() + "]";
            PlanKey chainKey = artifactSubscription.getConsumerJob().getParent().getPlanKey();
            return new ByChainKeyCacheInvalidator(description, chainKey);
        });
    }

    public static Pair<Class<?>, CacheInvalidators.InvalidatorFactory> newPlanRepositoryLinkInvalidator(Class<PlanRepositoryLink> clazz) {
        return Pair.pair(clazz, o -> {
            PlanRepositoryLink planRepositoryLink = (PlanRepositoryLink)clazz.cast(o);
            String description = "planRepositoryLink[" + planRepositoryLink.getId() + "]";
            PlanKey chainKey = planRepositoryLink.getPlan().getPlanKey();
            return new ByChainKeyCacheInvalidator(description, chainKey).withReindex();
        });
    }

    public static Pair<Class<?>, CacheInvalidators.InvalidatorFactory> newVariableDefinition(Class<VariableDefinition> clazz) {
        return Pair.pair(clazz, o -> {
            VariableDefinition variableDefinition = (VariableDefinition)clazz.cast(o);
            String description = "variable[" + variableDefinition.getKey() + "]";
            Plan plan = variableDefinition.getPlan();
            if (plan == null) {
                return NO_OP_INVALIDATOR;
            }
            PlanKey chainKey = plan.getPlanKey();
            return new ByChainKeyCacheInvalidator(description, chainKey);
        });
    }

    public static Pair<Class<?>, CacheInvalidators.InvalidatorFactory> newLabellingInvalidator(Class<Labelling> clazz) {
        return Pair.pair(clazz, o -> {
            Labelling labelling = (Labelling)clazz.cast(o);
            String description = "labelling[" + labelling.getId() + "]";
            Plan plan = labelling.getPlan();
            if (plan == null) {
                return NO_OP_INVALIDATOR;
            }
            PlanKey chainKey = plan.getPlanKey();
            return new ByChainKeyCacheInvalidator(description, chainKey);
        });
    }
}

