/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.invalidators;

import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.hibernate.invalidators.BranchCommitInformationInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.BranchMetadataInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.BuildDefinitionInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.ByKeyInvalidators;
import com.atlassian.bamboo.hibernate.invalidators.PlanInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.ProjectInvalidator;
import com.atlassian.bamboo.hibernate.invalidators.StageInvalidator;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinition;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscription;
import com.atlassian.bamboo.plan.branch.BranchCommitInformation;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.atlassian.fugue.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class CacheInvalidators {
    private static final Collection<Pair<Class<?>, InvalidatorFactory>> CLASSES_AND_INVALIDATORS = Arrays.asList(Pair.pair(ImmutablePlan.class, PlanInvalidator::new), Pair.pair(ImmutableChainStage.class, StageInvalidator::new), Pair.pair(Project.class, ProjectInvalidator::new), Pair.pair(BranchCommitInformation.class, BranchCommitInformationInvalidator::new), Pair.pair(BranchMetadataInvalidator.class, BranchMetadataInvalidator::new), Pair.pair(DefaultBuildDefinitionForBuild.class, BuildDefinitionInvalidator::new), ByKeyInvalidators.newLabellingInvalidator(Labelling.class), ByKeyInvalidators.newArtifactDefinitionInvalidator(ArtifactDefinition.class), ByKeyInvalidators.newArtifactSubscriptionInvalidator(ArtifactSubscription.class), ByKeyInvalidators.newPlanRepositoryLinkInvalidator(PlanRepositoryLink.class), ByKeyInvalidators.newVariableDefinition(VariableDefinition.class));
    private static final LoadingCache<Class<?>, Optional<InvalidatorFactory>> INVALIDATORS = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<InvalidatorFactory>>(){

        public Optional<InvalidatorFactory> load(Class<?> entityClass) throws Exception {
            for (Pair<Class<?>, InvalidatorFactory> classAndInvalidator : CLASSES_AND_INVALIDATORS) {
                if (!((Class)classAndInvalidator.left()).isAssignableFrom(entityClass)) continue;
                return Optional.of((InvalidatorFactory)classAndInvalidator.right());
            }
            return Optional.empty();
        }
    });

    private CacheInvalidators() {
    }

    public static Set<PlanKey> getAffectedPlanKeys(Cache<PlanKey, ImmutableChain> planKeyChainMap, Predicate<ImmutableChain> predicate) {
        return planKeyChainMap.asMap().values().stream().filter(predicate).map(PlanIdentifier::getPlanKey).collect(Collectors.toSet());
    }

    @NotNull
    public static Optional<ImmutablePlanCacheService.CacheInvalidator> forEntity(Object entity) {
        Class<?> entityClass = entity.getClass();
        return ((Optional)INVALIDATORS.getUnchecked(entityClass)).map(invalidatorFactory -> (ImmutablePlanCacheService.CacheInvalidator)invalidatorFactory.apply(entity));
    }

    @FunctionalInterface
    static interface InvalidatorFactory
    extends Function<Object, ImmutablePlanCacheService.CacheInvalidator> {
    }
}

