/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.hibernate.invalidators;

import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlanCacheService;
import com.atlassian.bamboo.plan.cache.index.PlanCacheIndices;
import com.atlassian.bamboo.project.Project;
import com.google.common.cache.Cache;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class ProjectInvalidator
implements ImmutablePlanCacheService.CacheInvalidator {
    private final String projectKey;

    ProjectInvalidator(Object project) {
        this((Project)project);
    }

    private ProjectInvalidator(Project project) {
        this.projectKey = project.getKey();
    }

    public String getDescription() {
        return "project [" + this.projectKey + "]";
    }

    public void getChainsToInvalidateAndReindex(@NotNull ImmutablePlanCacheService immutablePlanCacheService, @NotNull Cache<PlanKey, ImmutableChain> planKeyChainMap, @NotNull PlanCacheIndices planCacheIndices, @NotNull Set<PlanKey> chainsToInvalidate, @NotNull Set<PlanKey> chainsToReindex) {
        planKeyChainMap.asMap().values().stream().map(PlanIdentifier::getPlanKey).filter(planKey -> PlanKeys.getProjectKeyPart((PlanKey)planKey).equals(this.projectKey)).forEach(chainsToInvalidate::add);
    }
}

