/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index.quicksearch;

import com.atlassian.bamboo.index.quicksearch.QuickSearchItem;
import com.atlassian.bamboo.index.quicksearch.QuickSearchItemDao;
import com.atlassian.bamboo.index.quicksearch.QuickSearchItemImpl;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickSearchItemDaoImpl
extends BambooHibernateObjectDao<QuickSearchItem>
implements QuickSearchItemDao {
    private static final Logger log = Logger.getLogger(QuickSearchItemDaoImpl.class);

    public boolean reIndexItem(@NotNull QuickSearchItem.Type type, long id, @NotNull Iterable<String> searchTerms) {
        return this.reIndexItem(type, id, id, searchTerms);
    }

    public boolean reIndexItem(final @NotNull QuickSearchItem.Type type, final long id, long aclId, @NotNull Iterable<String> searchTerms) {
        List existingItems = new JpaUtils.CriteriaQuery<QuickSearchItemImpl, QuickSearchItemImpl>(this.getSessionFactory(), QuickSearchItemImpl.class, QuickSearchItemImpl.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.entity.get("entityId"), (Object)id), (Expression)this.cb.equal((Expression)this.entity.get("type"), (Object)type)));
            }
        }.getResultList();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Indexing %s id: %d with search terms %s", type, id, Iterables.toString(searchTerms)));
        }
        ArrayList toRemove = new ArrayList();
        HashMap existingItemsMap = new HashMap();
        existingItems.forEach(quickSearchItem -> {
            if (!existingItemsMap.containsKey(quickSearchItem.getSearchTerm())) {
                existingItemsMap.put(quickSearchItem.getSearchTerm(), quickSearchItem);
            } else {
                toRemove.add(quickSearchItem);
            }
        });
        ArrayList<QuickSearchItemImpl> itemsToAdd = new ArrayList<QuickSearchItemImpl>();
        HashSet keys = new HashSet(existingItemsMap.keySet());
        for (String searchTerm : searchTerms) {
            String lowerCased = searchTerm.toLowerCase();
            existingItemsMap.remove(lowerCased);
            if (!keys.add(lowerCased)) continue;
            itemsToAdd.add(new QuickSearchItemImpl(type, id, aclId, lowerCased));
        }
        toRemove.addAll(existingItemsMap.values());
        this.deleteAll(toRemove);
        this.saveAll(itemsToAdd);
        return !itemsToAdd.isEmpty() || !existingItemsMap.isEmpty();
    }

    public void deIndexItem(final @NotNull QuickSearchItem.Type type, final long id) {
        new JpaUtils.CriteriaDelete<QuickSearchItemImpl>(this.getSessionFactory(), QuickSearchItemImpl.class){

            @Override
            public void apply() {
                this.delete.where((Expression)this.cb.and((Expression)this.cb.equal((Expression)this.entity.get("entityId"), (Object)id), (Expression)this.cb.equal((Expression)this.entity.get("type"), (Object)type)));
            }
        }.executeUpdate();
    }

    @NotNull
    public List<QuickSearchItem> findMatchingItems(@NotNull Set<String> searchTerms, int offset, int pageSize) {
        return this.findMatchingItems(searchTerms, null, offset, pageSize);
    }

    @NotNull
    public List<QuickSearchItem> findMatchingItems(final @NotNull Set<String> searchTerms, final @Nullable QuickSearchItem.Type type, int offset, int pageSize) {
        return new JpaUtils.CriteriaQuery<QuickSearchItemImpl, QuickSearchItem>(this.getSessionFactory(), QuickSearchItemImpl.class, QuickSearchItem.class){

            @Override
            public void apply() {
                Predicate[] predicates = (Predicate[])searchTerms.stream().map(s -> this.cb.like((Expression)this.entity.get("searchTerm"), QuickSearchItemDaoImpl.this.convertSearchTermToLikeExpression(s))).toArray(Predicate[]::new);
                if (type != null) {
                    Predicate[] predicatesWithType = new Predicate[predicates.length + 1];
                    System.arraycopy(predicates, 0, predicatesWithType, 1, predicates.length);
                    predicatesWithType[0] = this.cb.equal((Expression)this.entity.get("type"), (Object)type);
                    predicates = predicatesWithType;
                }
                this.q.select((Selection)this.entity).where(predicates).orderBy(new Order[]{this.cb.asc(this.cb.length((Expression)this.entity.get("searchTerm"))), this.cb.asc((Expression)this.entity.get("type")), this.cb.desc((Expression)this.entity.get("id"))});
            }
        }.getResultList(offset, pageSize);
    }

    public void deIndexAll() {
        new JpaUtils.CriteriaDelete<QuickSearchItemImpl>(this.getSessionFactory(), QuickSearchItemImpl.class){

            @Override
            public void apply() {
            }
        }.executeUpdate();
    }

    public void indexItems(@NotNull List<QuickSearchItem> items) {
        this.saveAll(items);
    }
}

