/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jpa;

import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.versioning.VersionedEntityComponent;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class JpaUtils {
    public static Accumulator accumulator() {
        return new Accumulator();
    }

    public static <T, E> List<T> listCriteria(DbmsBean dbmsBean, Session session, Class<T> targetClass, Class<? extends T> persistentClass, String propertyName, Collection<E> values) {
        if (values.size() == 0) {
            return Collections.emptyList();
        }
        int maximumNumberOfValuesForIn = HibernateDaoUtils.getMaximumNumberOfValuesForIn(dbmsBean);
        CriteriaBuilder cb = session.getCriteriaBuilder();
        javax.persistence.criteria.CriteriaQuery cq = cb.createQuery(targetClass);
        Root root = cq.from(persistentClass);
        cq.select((Selection)root);
        if (values.size() <= maximumNumberOfValuesForIn) {
            cq.where((Expression)root.get(propertyName).in(values));
            Query query = session.createQuery(cq);
            return query.getResultList();
        }
        ArrayList results = new ArrayList(values.size());
        Iterable lists = Iterables.partition(values, (int)maximumNumberOfValuesForIn);
        lists.forEach(list -> {
            cq.where((Expression)root.get("id").in((Collection)list));
            Query query = session.createQuery(cq);
            results.addAll(query.getResultList());
        });
        return results;
    }

    public static class Accumulator {
        private List<Predicate> predicates = new ArrayList<Predicate>();

        public Accumulator add(Predicate predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Accumulator add(List<Predicate> predicates) {
            this.predicates.addAll(predicates);
            return this;
        }

        public void toWhere(javax.persistence.criteria.CriteriaQuery<?> q) {
            q.where(this.predicates.toArray(new Predicate[0]));
        }
    }

    public static abstract class CriteriaVersionUpdater<E, R, T> {
        private final Session session;
        protected final CriteriaBuilder cb;
        protected final javax.persistence.criteria.CriteriaQuery<R> q;
        protected final Root<? extends E> entity;
        protected final VersioningSupplement<T> versioningSupplement;

        public CriteriaVersionUpdater(SessionFactory sessionFactory, Class<? extends E> entity, Class<R> result, VersioningSupplement<T> versioningSupplement) {
            this.session = sessionFactory.getCurrentSession();
            this.cb = this.session.getCriteriaBuilder();
            this.q = this.cb.createQuery(result);
            this.entity = this.q.from(entity);
            this.versioningSupplement = versioningSupplement;
        }

        protected abstract void apply();

        public void incrementRootVersion() {
            VersionedEntityComponent versionedEntityComponent;
            this.apply();
            Object res = this.session.createQuery(this.q).uniqueResult();
            if (res != null && (versionedEntityComponent = (VersionedEntityComponent)Narrow.downTo((Object)res, VersionedEntityComponent.class)) != null) {
                this.versioningSupplement.incrementVersion(versionedEntityComponent.getRoot(), this.session);
            }
        }
    }

    public static abstract class CriteriaQuery<E, R> {
        private final Session session;
        protected final CriteriaBuilder cb;
        protected final javax.persistence.criteria.CriteriaQuery<R> q;
        protected final Root<? extends E> entity;

        public CriteriaQuery(SessionFactory sessionFactory, Class<? extends E> entity, Class<R> result) {
            this.session = sessionFactory.getCurrentSession();
            this.cb = this.session.getCriteriaBuilder();
            this.q = this.cb.createQuery(result);
            this.entity = this.q.from(entity);
        }

        protected abstract void apply();

        public R getSingleResult() {
            this.apply();
            return (R)this.session.createQuery(this.q).getSingleResult();
        }

        public R uniqueResult() {
            this.apply();
            return (R)this.session.createQuery(this.q).uniqueResult();
        }

        public List<R> getResultList() {
            this.apply();
            return this.session.createQuery(this.q).getResultList();
        }

        public List<R> getResultList(int firstResult, int maxResults) {
            this.apply();
            Query query = this.session.createQuery(this.q).setFirstResult(firstResult > 0 ? firstResult : 0);
            if (maxResults > 0) {
                query = query.setMaxResults(maxResults);
            }
            return query.getResultList();
        }
    }

    public static abstract class PartitionedCriteriaDelete<T, I>
    extends AbstractCriteriaDelete<T> {
        private final int partitionSize;

        protected PartitionedCriteriaDelete(DbmsBean dbmsBean, SessionFactory sessionFactory, Class<T> entity) {
            super(sessionFactory, entity);
            this.partitionSize = HibernateDaoUtils.getMaximumNumberOfValuesForIn(dbmsBean);
        }

        public abstract void apply(List<I> var1);

        public void executeUpdates(Collection<I> values) {
            if (values.isEmpty()) {
                return;
            }
            for (List partition : Iterables.partition(new HashSet<I>(values), (int)Math.min(this.partitionSize, values.size()))) {
                this.apply(partition);
                this.session.createQuery(this.delete).executeUpdate();
            }
        }
    }

    public static abstract class CriteriaDelete<T>
    extends AbstractCriteriaDelete<T> {
        protected CriteriaDelete(SessionFactory sessionFactory, Class<T> entity) {
            super(sessionFactory, entity);
        }

        public abstract void apply();

        public int executeUpdate() {
            this.apply();
            return this.session.createQuery(this.delete).executeUpdate();
        }
    }

    private static abstract class AbstractCriteriaDelete<T> {
        final Session session;
        protected final CriteriaBuilder cb;
        protected final javax.persistence.criteria.CriteriaDelete<T> delete;
        protected final Root<T> entity;

        AbstractCriteriaDelete(SessionFactory sessionFactory, Class<T> entity) {
            this.session = sessionFactory.getCurrentSession();
            this.cb = this.session.getCriteriaBuilder();
            this.delete = this.cb.createCriteriaDelete(entity);
            this.entity = this.delete.from(entity);
        }
    }

    public static abstract class CriteriaUpdate<T> {
        private final Session session;
        protected final CriteriaBuilder cb;
        protected final javax.persistence.criteria.CriteriaUpdate<T> update;
        protected final Root<T> entity;

        protected CriteriaUpdate(SessionFactory sessionFactory, Class<T> entity) {
            this.session = sessionFactory.getCurrentSession();
            this.cb = this.session.getCriteriaBuilder();
            this.update = this.cb.createCriteriaUpdate(entity);
            this.entity = this.update.from(entity);
        }

        public abstract void apply();

        public int executeUpdate() {
            this.apply();
            return this.session.createQuery(this.update).executeUpdate();
        }
    }
}

