/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.labels;

import com.atlassian.bamboo.cluster.BambooClusterSettings;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.LabelCount;
import com.atlassian.bamboo.labels.LabelCountImpl;
import com.atlassian.bamboo.labels.LabelDao;
import com.atlassian.bamboo.labels.LabelImpl;
import com.atlassian.bamboo.labels.LabelImpl_;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.labels.LabellingImpl_;
import com.atlassian.bamboo.persistence.BambooHibernate;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.versioning.PlanVersioningSupplement;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import com.atlassian.core.bean.EntityObject;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class LabelHibernateDao
extends BambooHibernateObjectDao
implements LabelDao {
    private static final Logger log = Logger.getLogger(LabelHibernateDao.class);
    private BambooClusterSettings bambooClusterSettings;
    private final VersioningSupplement<Plan> versioningSupplement;

    @Inject
    public LabelHibernateDao(@NotNull BambooClusterSettings bambooClusterSettings) {
        this.versioningSupplement = new PlanVersioningSupplement(bambooClusterSettings);
    }

    public Class getPersistentClass() {
        return LabelImpl.class;
    }

    @Nullable
    public Label findLabelByNameAndNamespace(final String name, final String namespace) {
        return (Label)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabelByNameAndNamespace").setParameter("name", (Object)name).setParameter("namespace", (Object)namespace).uniqueResult();
            }
        });
    }

    @NotNull
    public List<Label> findLabelsByNameAndNamespace(final List<String> names, final String namespace) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Label>>(){

            public List<Label> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(LabelHibernateDao.this.getPersistentClass()).add(Restrictions.in((String)"name", (Collection)names)).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).list();
            }
        });
    }

    @Nullable
    public Labelling findLabellingByResultsSummary(final Label label, final ResultsSummary resultsSummary) {
        return (Labelling)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingByBuildResultSummaryAndLabel").setParameter("label", (Object)label).setParameter("buildResultsSummary", (Object)resultsSummary).setCacheable(true).uniqueResult();
            }
        });
    }

    @Nullable
    public Labelling findLabellingByResultsSummary(final String name, final String namespace, final ResultsSummary buildResultsSummary) {
        return (Labelling)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingByBuildResultSummaryAndNameAndNamespace").setParameter("name", (Object)name).setParameter("namespace", (Object)namespace).setParameter("buildResultsSummary", (Object)buildResultsSummary).setCacheable(true).uniqueResult();
            }
        });
    }

    @Nullable
    public Labelling findLabellingByBuild(final Label label, final ImmutablePlan plan) {
        List labellings = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Labelling>>(){

            public List<Labelling> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingByBuild").setParameter("label", (Object)label).setParameter("planId", (Object)plan.getId()).list();
            }
        });
        return (Labelling)Iterables.getFirst((Iterable)labellings, null);
    }

    @Nullable
    public Labelling findLabellingByBuild(final String name, final String namespace, final ImmutablePlan plan) {
        List labellings = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Labelling>>(){

            public List<Labelling> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingByBuild2").setParameter("name", (Object)name).setParameter("namespace", (Object)namespace).setParameter("planId", (Object)plan.getId()).list();
            }
        });
        return (Labelling)Iterables.getFirst((Iterable)labellings, null);
    }

    @Nullable
    public Labelling findLabellingByProject(final Label label, final Project project) {
        return (Labelling)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingByProject").setParameter("label", (Object)label).setParameter("project", (Object)project).uniqueResult();
            }
        });
    }

    public long getUsageCountForLabel(final Label label) {
        return ((Number)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                return (Number)session.getNamedQuery("getUsageCountForLabel").setParameter("label", (Object)label).uniqueResult();
            }
        })).longValue();
    }

    @NotNull
    public List<ResultsSummary> findResultsSummaryByNameAndNamespace(final String name, final String namespace) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ResultsSummary>>(){

            public List<ResultsSummary> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findResultsSummaryByNameAndNamespace").setParameter("name", (Object)name).setParameter("namespace", (Object)namespace).list();
            }
        });
    }

    @NotNull
    public List<LabelCount> findLabels(final String namespace, final int maxResults) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<LabelCount>>(){

            public List<LabelCount> doInHibernate(Session session) throws HibernateException {
                List list = session.getNamedQuery("findLabels").setParameter("namespace", (Object)namespace).setMaxResults(maxResults).list();
                ArrayList<LabelCount> labelCounts = new ArrayList<LabelCount>();
                for (Object[] o : list) {
                    Label label = (Label)LabelHibernateDao.this.getHibernateTemplate().load(LabelHibernateDao.this.getPersistentClass(), (Serializable)o[0]);
                    labelCounts.add((LabelCount)new LabelCountImpl(label, ((Number)o[1]).intValue()));
                }
                return labelCounts;
            }
        });
    }

    @NotNull
    public Set<Label> findPlanLabels(final String namespace) {
        List results = (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Label>>(){

            public List<Label> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(LabelHibernateDao.this.getPersistentClass()).createAlias("labellings", "labellings").add(Restrictions.isNull((String)"labellings.buildResultsSummary")).add((Criterion)Restrictions.eq((String)"namespace", (Object)namespace)).addOrder(org.hibernate.criterion.Order.asc((String)"name")).list();
            }
        });
        return ImmutableSortedSet.copyOf((Collection)results);
    }

    @NotNull
    public Set<Label> findPlanLabels(String namespace, @NotNull PlanIdentifier plan) {
        List results = (List)this.getHibernateTemplate().execute(session -> {
            CriteriaBuilder cb = session.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(Label.class);
            Root label = q.from(LabelImpl.class);
            CollectionJoin join = label.join(LabelImpl_.labellings);
            q.select((Selection)label).where(new Predicate[]{cb.isNull((Expression)join.get(LabellingImpl_.buildResultsSummary)), cb.equal((Expression)join.get(LabellingImpl_.plan), (Object)plan.getId()), cb.equal((Expression)label.get(LabelImpl_.namespace), (Object)namespace)}).orderBy(new Order[]{cb.asc((Expression)label.get(LabelImpl_.name))});
            return session.createQuery(q).getResultList();
        });
        return ImmutableSortedSet.copyOf((Collection)results);
    }

    @NotNull
    public List<LabelCount> findLabels(String namespace, int maxResults, Plan plan) {
        return (List)this.getHibernateTemplate().execute(session -> {
            List list = session.getNamedQuery("findLabelsByBuild").setParameter("namespace", (Object)namespace).setParameter("build", (Object)plan).setParameter("planKey", (Object)plan.getPlanKey().getKey()).setMaxResults(maxResults).list();
            ArrayList<LabelCountImpl> labelCounts = new ArrayList<LabelCountImpl>();
            for (Object[] o : list) {
                Label label = (Label)this.getHibernateTemplate().load(this.getPersistentClass(), (Serializable)o[0]);
                labelCounts.add(new LabelCountImpl(label, ((Number)o[1]).intValue()));
            }
            return labelCounts;
        });
    }

    @NotNull
    public List<LabelCount> findLabels(String namespace, int maxResults, Project project) {
        return (List)this.getHibernateTemplate().execute(session -> {
            List list = session.getNamedQuery("findLabelsByProject").setParameter("namespace", (Object)namespace).setParameter("project", (Object)project).setMaxResults(maxResults).list();
            ArrayList<LabelCountImpl> labelCounts = new ArrayList<LabelCountImpl>();
            for (Object[] o : list) {
                Label label = (Label)this.getHibernateTemplate().load(this.getPersistentClass(), (Serializable)o[0]);
                labelCounts.add(new LabelCountImpl(label, ((Number)o[1]).intValue()));
            }
            return labelCounts;
        });
    }

    @NotNull
    public List<Labelling> findLabels(final ImmutablePlan plan) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Labelling>>(){

            public List<Labelling> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingsByBuildOnly").setParameter("build", (Object)plan, BambooHibernate.entity(plan)).list();
            }
        });
    }

    @NotNull
    public List<Labelling> findLabels(final Project project) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Labelling>>(){

            public List<Labelling> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingsByProjectOnly").setParameter("project", (Object)project).list();
            }
        });
    }

    @NotNull
    public List<Labelling> findLabellingByUser(final String userName) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Labelling>>(){

            public List<Labelling> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findLabellingByUser").setParameter("userName", (Object)userName).list();
            }
        });
    }

    public void saveLabel(@NotNull Label label) {
        this.save((EntityObject)label);
    }

    public void saveLabelling(@NotNull Labelling labelling) {
        this.save((EntityObject)labelling);
        this.incrementRootVersion(labelling);
    }

    public void remove(@NotNull Labelling labelling) {
        this.incrementRootVersion(labelling);
        super.remove((EntityObject)labelling);
    }

    private void incrementRootVersion(@NotNull Labelling labelling) {
        this.getHibernateTemplate().execute(session -> {
            this.versioningSupplement.incrementVersion((Object)((Plan)labelling.getRoot()), session);
            return null;
        });
    }

    @NotNull
    public Set<String> getResultSummaryLabelNames(final @NotNull ResultsSummary resultsSummary) {
        return ImmutableSortedSet.copyOf((Collection)((Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<String>>(){

            public List<String> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("getResultSummaryLabelNames").setParameter("resultsSummary", (Object)resultsSummary).list();
            }
        })));
    }
}

