/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.notification;

import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.notification.NotificationDao;
import com.atlassian.bamboo.notification.NotificationRule;
import com.atlassian.bamboo.notification.NotificationRuleImpl;
import com.atlassian.bamboo.notification.NotificationSet;
import com.atlassian.bamboo.notification.NotificationSetImpl;
import com.atlassian.bamboo.notification.UsersNotification;
import com.atlassian.bamboo.persistence.BambooHibernateObjectDao;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class NotificationHibernateDao
extends BambooHibernateObjectDao
implements NotificationDao {
    public Class getPersistentClass() {
        return NotificationRuleImpl.class;
    }

    public void deleteNotification(NotificationRule rule) {
        rule.setNotificationSet(null);
        this.remove((EntityObject)rule);
    }

    public void saveNotificationRule(NotificationRule newRule) {
        this.save((EntityObject)newRule);
    }

    public void saveNotificationSet(@NotNull NotificationSet notificationSet) {
        Preconditions.checkArgument((boolean)(notificationSet instanceof EntityObject));
        this.save((EntityObject)notificationSet);
        this.getHibernateTemplate().flush();
    }

    @NotNull
    public List<UsersNotification> getNotificationRulesForRecipients(final @NotNull String recipientType, final @NotNull Collection<String> recipients) {
        Validate.notEmpty(recipients, (String)"recipients list must not be empty", (Object[])new Object[0]);
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<UsersNotification>>(){

            public List<UsersNotification> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findNotificationsForRecipient").setParameterList("recipientValues", recipients).setParameter("recipientType", (Object)recipientType).setParameter("markedForDeletion", (Object)Boolean.FALSE).list();
            }
        });
    }

    @NotNull
    public List<UsersNotification> getWatcherNotificationRulesForRecipientUsername(final @NotNull String recipientUsername) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<UsersNotification>>(){

            public List<UsersNotification> doInHibernate(Session session) throws HibernateException {
                return session.getNamedQuery("findWatcherNotificationsForRecipient").setParameter("recipientType", (Object)"com.atlassian.bamboo.plugin.system.notifications:recipient.watcher").setParameter("markedForDeletion", (Object)Boolean.FALSE).setParameter("username", (Object)recipientUsername).setParameter("favourite", (Object)":favourite").list();
            }
        });
    }

    @NotNull
    public List<NotificationSet> getNotificationSetsForType(final NotificationSet.NotificationSetType type) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<NotificationSet>>(){

            public List<NotificationSet> doInHibernate(Session session) throws HibernateException {
                return session.createCriteria(NotificationSet.class).add((Criterion)Restrictions.eq((String)"notificationSetType", (Object)type)).list();
            }
        });
    }

    @Nullable
    public NotificationSet getNotificationSetForId(final long notificationSetId) {
        return (NotificationSet)new JpaUtils.CriteriaQuery<NotificationSetImpl, NotificationSet>(this.getSessionFactory(), NotificationSetImpl.class, NotificationSet.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).where((Expression)this.cb.equal((Expression)this.entity.get("id"), (Object)notificationSetId));
            }
        }.getSingleResult();
    }
}

