/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.oid;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.core.IdGenerator;
import com.atlassian.bamboo.oid.IdGeneratorDao;
import com.atlassian.bamboo.oid.IdGeneratorEntity;
import com.atlassian.bamboo.util.BambooSpringUtils;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.List;
import java.util.function.ToLongFunction;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.transaction.support.TransactionTemplate;

public class IdGeneratorDaoImpl
extends HibernateDaoSupport
implements IdGeneratorDao {
    private static final Logger log = Logger.getLogger(IdGeneratorDaoImpl.class);
    private static final int RANGE_SIZE = 1024;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private TransactionTemplate newTxTemplate;

    @PostConstruct
    private void ensureNewTransactions() {
        this.newTxTemplate = BambooSpringUtils.requiresNew((TransactionTemplate)this.newTxTemplate);
    }

    @NotNull
    public Range<Long> nextIdRange(@NotNull BambooEntityType entityType) {
        String name = entityType.name();
        Range<Long> range = this.getAndUpdateNextId(entityType, oldNextId -> oldNextId + 1024L);
        log.debug((Object)String.format("IdGenerator name=%s; range=%s", name, range));
        return range;
    }

    public void resetId(@NotNull BambooEntityOid lastOid) {
        this.getAndUpdateNextId(lastOid.getEntityType(), oldNextId -> Math.max(oldNextId, lastOid.getEntityOid() + 1L));
    }

    @NotNull
    public List<IdGenerator> findAll() {
        return this.getHibernateTemplate().find("from " + IdGeneratorEntity.class.getCanonicalName(), new Object[0]);
    }

    public void saveNextId(String name, long nextId) {
        IdGeneratorEntity entity = new IdGeneratorEntity();
        entity.setName(name);
        entity.setNextId(nextId);
        this.getHibernateTemplate().save((Object)entity);
    }

    private Range<Long> getAndUpdateNextId(@NotNull BambooEntityType entityType, @NotNull ToLongFunction<Long> nextIdFunction) {
        return (Range)this.newTxTemplate.execute(tx -> {
            String name;
            Session session = this.sessionFactory.getCurrentSession();
            IdGeneratorEntity idGenerator = (IdGeneratorEntity)session.get(IdGeneratorEntity.class, (Serializable)((Object)(name = entityType.name())));
            if (idGenerator == null) {
                idGenerator = new IdGeneratorEntity(name, 1L);
            }
            long nextId = idGenerator.getNextId();
            long newNextId = nextIdFunction.applyAsLong(nextId);
            Range range = Range.closedOpen((Comparable)Long.valueOf(nextId), (Comparable)Long.valueOf(newNextId));
            idGenerator.setNextId(newNextId);
            session.saveOrUpdate((Object)idGenerator);
            return range;
        });
    }
}

