/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.bamboo.persistence.BambooConnectionCallback;
import com.atlassian.bamboo.persistence.BambooConnectionSupplyingCallback;
import org.jetbrains.annotations.NotNull;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class BambooConnectionTemplate {
    private final HibernateTemplate hibernateTemplate;
    private final TransactionTemplate transactionTemplate;

    public BambooConnectionTemplate(HibernateTemplate hibernateTemplate, TransactionTemplate transactionTemplate) {
        this.hibernateTemplate = hibernateTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public void execute(final BambooConnectionCallback connectionCallback) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(@NotNull TransactionStatus status) {
                BambooConnectionTemplate.this.hibernateTemplate.executeWithNativeSession(session -> {
                    session.doWork(connectionCallback::doInHibernateTransaction);
                    return null;
                });
            }
        });
    }

    public <T> T execute(BambooConnectionSupplyingCallback<T> connectionCallback) {
        return (T)this.transactionTemplate.execute(transactionStatus -> this.hibernateTemplate.executeWithNativeSession(session -> session.doReturningWork(connectionCallback::doInTransaction)));
    }
}

