/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooObjectDao;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public abstract class BambooHibernateObjectDao
extends HibernateDaoSupport
implements BambooObjectDao {
    private static final Logger log = Logger.getLogger(BambooHibernateObjectDao.class);

    public BambooObject findById(long id) {
        return (BambooObject)this.getByClassId(id);
    }

    public <T> T findById(long id, Class<T> persistentClass) {
        return (T)this.getHibernateTemplate().get(persistentClass, (Serializable)Long.valueOf(id));
    }

    public void save(EntityObject objectToSave) {
        this.updateModificationData(objectToSave);
        this.saveRaw(objectToSave);
    }

    protected void updateModificationData(EntityObject objectToSave) {
        Date date = objectToSave.getCurrentDate();
        objectToSave.setLastModificationDate(date);
        if (objectToSave.getCreationDate() == null) {
            objectToSave.setCreationDate(date);
        }
    }

    public void replicate(final Object objectToReplicate) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.replicate(objectToReplicate, ReplicationMode.OVERWRITE);
                return null;
            }
        });
    }

    public void saveRaw(EntityObject objectToSave) {
        this.getHibernateTemplate().saveOrUpdate((Object)objectToSave);
    }

    public void refresh(final EntityObject objectToRefresh) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                session.refresh((Object)objectToRefresh);
                return null;
            }
        });
    }

    public void remove(EntityObject objectToRemove) {
        try {
            this.getHibernateTemplate().delete((Object)objectToRemove);
        }
        catch (Exception e) {
            log.error((Object)"remove error!", (Throwable)e);
            throw new InfrastructureException((Throwable)e);
        }
    }

    public List findAll() {
        return this.findAllSorted(null);
    }

    public List findAllSorted(@Nullable String sortField) {
        String query = "FROM " + this.getPersistentClass().getName() + " result";
        if (sortField != null) {
            query = query + " ORDER BY LOWER(result." + sortField + ")";
        }
        final String finalQuery = query;
        List result = (List)this.getHibernateTemplate().execute(new HibernateCallback<List<?>>(){

            public List<?> doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery(finalQuery).setCacheable(true);
                BambooSessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)BambooHibernateObjectDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    private EntityObject getByClassId(final long id) {
        return (EntityObject)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.get(BambooHibernateObjectDao.this.getPersistentClass(), (Serializable)Long.valueOf(id));
            }
        });
    }
}

