/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.bamboo.persistence.BambooOpenSessionTemplate;
import javax.inject.Inject;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class BambooOpenSessionTemplateImpl
implements BambooOpenSessionTemplate {
    @Inject
    private SessionFactory sessionFactory;

    protected Session openSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = null;
        try {
            session = sessionFactory.openSession();
            session.setHibernateFlushMode(FlushMode.MANUAL);
        }
        catch (HibernateException var4) {
            HibernateException ex = var4;
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", (Throwable)ex);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSession(@NotNull Runnable runnable) {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"No SessionFactory set");
        if (!TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            Session session = this.openSession(this.sessionFactory);
            try {
                TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
                runnable.run();
            }
            finally {
                SessionFactoryUtils.closeSession((Session)session);
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            }
        } else {
            runnable.run();
        }
    }
}

