/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class BambooTransactionHibernateTemplate
implements TransactionAndHibernateTemplate {
    private final HibernateTemplate hibernateTemplate;
    private final TransactionTemplate transactionTemplate;

    public BambooTransactionHibernateTemplate(HibernateTemplate hibernateTemplate, TransactionTemplate transactionTemplate) {
        this.hibernateTemplate = hibernateTemplate;
        this.transactionTemplate = transactionTemplate;
    }

    public <T> T execute(TransactionCallback<T> action) throws TransactionException {
        return (T)this.transactionTemplate.execute(action);
    }

    public <T> T execute(HibernateCallback<T> hibernateCallback) {
        return this.execute(status -> this.hibernateTemplate.executeWithNativeSession(hibernateCallback));
    }

    public void doWork(final Work work) throws HibernateException {
        this.execute(new HibernateCallback<Object>(){

            @Nullable
            public Object doInHibernate(Session session) throws HibernateException {
                session.doWork(work);
                return null;
            }
        });
    }
}

