/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence;

import com.atlassian.bamboo.persistence.ResettableTableHiLoGenerator;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.jetbrains.annotations.TestOnly;

public class ImportAwareGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = Logger.getLogger(ImportAwareGenerator.class);
    private static final ThreadLocal<Pair<Object, Serializable>> idHolder = new ThreadLocal();
    private final ResettableTableHiLoGenerator delegate = new ResettableTableHiLoGenerator();

    public synchronized Serializable generate(SharedSessionContractImplementor session, Object obj) {
        Pair<Object, Serializable> objectAndId = idHolder.get();
        if (objectAndId == null || objectAndId.getLeft() != obj) {
            return this.delegate.generate(session, obj);
        }
        Serializable id = (Serializable)objectAndId.getRight();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using predefined id " + ImportAwareGenerator.getIdString(objectAndId)));
        }
        idHolder.remove();
        return id;
    }

    public static void enterSaveWithIdContext(Object object, Serializable id) {
        Pair objectAndId = Pair.of((Object)object, (Object)id);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering 'save with id' context " + ImportAwareGenerator.getIdString((Pair<Object, Serializable>)objectAndId)));
        }
        Preconditions.checkState((idHolder.get() == null ? 1 : 0) != 0, (Object)"A nested 'save with id' call detected");
        idHolder.set((Pair<Object, Serializable>)objectAndId);
    }

    public static void leaveSaveWithIdContext() {
        Pair<Object, Serializable> keyAndId;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving 'save with id' context");
        }
        Preconditions.checkState(((keyAndId = idHolder.get()) == null ? 1 : 0) != 0, (Object)("A predefined id wasn't used: " + keyAndId));
    }

    @TestOnly
    public static void clearSaveWithIdContext() {
        idHolder.remove();
    }

    private static String getObjectIdString(Object obj) {
        return obj.getClass() + ":0x" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getIdString(Pair<Object, Serializable> keyAndId) {
        return ImportAwareGenerator.getObjectIdString(keyAndId.getLeft()) + " -> " + keyAndId.getRight();
    }

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) throws MappingException {
        this.delegate.configure(type, params, serviceRegistry);
    }

    public void registerExportables(Database database) {
        this.delegate.registerExportables(database);
    }

    public void initialize(SqlStringGenerationContext context) {
        this.delegate.initialize(context);
    }

    public boolean supportsJdbcBatchInserts() {
        return this.delegate.supportsJdbcBatchInserts();
    }

    public ResettableTableHiLoGenerator getResettableGenerator() {
        return this.delegate;
    }
}

