/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence3;

import bucket.core.persistence.hibernate.schema.MetadataImplementorHolder;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hibernate.MappingException;
import org.hibernate.mapping.PersistentClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDiscriminatorRegistry<T, X extends T> {
    private static final Logger log = Logger.getLogger(AbstractDiscriminatorRegistry.class);
    private final Set<Pair<String, Class<? extends T>>> mappings;
    private final Map<Class<? extends T>, String> discriminators = new HashMap<Class<? extends T>, String>();
    private final LoadingCache<Class<? extends T>, Set<String>> discriminatorsForType = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends T>, Set<String>>(){

        public Set<String> load(Class<? extends T> from) {
            HashSet<String> discriminatorValues = new HashSet<String>();
            for (Pair pair : AbstractDiscriminatorRegistry.this.mappings) {
                if (!from.isAssignableFrom((Class)pair.getSecond())) continue;
                String discriminatorValue = (String)pair.getFirst();
                discriminatorValues.add(discriminatorValue);
            }
            return Collections.unmodifiableSet(discriminatorValues);
        }
    });

    protected abstract Class<X> getBaseClass();

    public AbstractDiscriminatorRegistry() throws MappingException {
        HashSet<Pair> mappings = new HashSet<Pair>();
        Collection persistentClasses = MetadataImplementorHolder.getMetadataImplementor().getEntityBindings();
        for (PersistentClass persistentClass : persistentClasses) {
            Class mappedClass = persistentClass.getMappedClass();
            if (!this.getBaseClass().isAssignableFrom(mappedClass) || this.getBaseClass().equals(mappedClass)) continue;
            this.discriminators.put(mappedClass, persistentClass.getDiscriminatorValue());
            Pair planMapping = Pair.make((Object)persistentClass.getDiscriminatorValue(), (Object)mappedClass);
            if (mappings.contains(planMapping)) continue;
            mappings.add(planMapping);
        }
        this.mappings = Collections.unmodifiableSet(mappings);
    }

    public Set<String> getDiscriminatorsForType(Class<? extends T> aClass) {
        return (Set)this.discriminatorsForType.getUnchecked(aClass);
    }

    public String getDiscriminatorForType(Class<? extends T> aClass) {
        return this.discriminators.get(aClass);
    }

    @Nullable
    public Class<? extends T> getTypeForDiscriminator(@NotNull String discriminator) {
        for (Pair<String, Class<? extends T>> pair : this.mappings) {
            if (!((String)pair.getFirst()).equals(discriminator)) continue;
            return (Class)pair.getSecond();
        }
        return null;
    }

    public boolean isConcretelyMappedType(Class<? extends T> aClass) {
        Set discriminators = (Set)this.discriminatorsForType.getUnchecked(aClass);
        return discriminators != null && discriminators.size() == 1;
    }
}

