/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence3;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.BambooSessionFactoryUtils;
import com.atlassian.bamboo.persistence3.BambooObjectDao;
import com.atlassian.bamboo.persistence3.HibernateDaoUtils;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public abstract class BambooHibernateObjectDao<T extends BambooObject>
extends StatelessSessionHibernateDaoSupport
implements BambooObjectDao<T> {
    public void save(@NotNull T t) {
        HibernateDaoUtils.updateTimestamp(t);
        this.getCacheAwareHibernateTemplate().saveOrUpdate(t);
    }

    public <E extends T> void saveAll(@NotNull Collection<E> entities) {
        entities.forEach(HibernateDaoUtils::updateTimestamp);
        HibernateDaoUtils.saveOrUpdateAll(this.getCacheAwareHibernateTemplate().getSessionFactory().getCurrentSession(), entities);
    }

    @NotNull
    public T merge(@NotNull T unmanagedEntity, @NotNull Class<? extends T> entityClass) {
        BambooObject managedEntity;
        BambooObject bambooObject = managedEntity = unmanagedEntity.getId() > 0L ? (BambooObject)this.findById(unmanagedEntity.getId(), entityClass) : null;
        if (managedEntity != null) {
            HibernateDaoUtils.copyTimestamp(managedEntity, unmanagedEntity);
        }
        HibernateDaoUtils.updateTimestamp(unmanagedEntity);
        return (T)((BambooObject)this.getCacheAwareHibernateTemplate().merge(unmanagedEntity));
    }

    public void delete(@NotNull T t) {
        this.getCacheAwareHibernateTemplate().delete(t);
    }

    public <E extends T> void deleteAll(@NotNull Collection<E> entities) {
        this.getCacheAwareHibernateTemplate().deleteAll(entities);
    }

    @NotNull
    public <E extends T> Collection<E> findAll(final @NotNull Class<E> aClass) {
        return (Collection)this.getCacheAwareHibernateTemplate().execute(new HibernateCallback<List<E>>(){

            public List<E> doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(aClass);
                criteria.setCacheable(true);
                BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)BambooHibernateObjectDao.this.getSessionFactory());
                return criteria.list();
            }
        });
    }

    public <E extends T> long countAll(final @NotNull Class<E> aClass) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(aClass);
                criteria.setCacheable(true);
                criteria.setProjection(Projections.rowCount());
                BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)BambooHibernateObjectDao.this.getSessionFactory());
                return (Number)criteria.uniqueResult();
            }
        })).longValue();
    }

    public <E extends T> long countWithRestriction(final @NotNull Class<E> aClass, final @NotNull Criterion restriction) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Number>(){

            public Number doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(aClass);
                criteria.add(restriction);
                criteria.setCacheable(true);
                criteria.setProjection(Projections.rowCount());
                BambooSessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)BambooHibernateObjectDao.this.getSessionFactory());
                return (Number)criteria.uniqueResult();
            }
        })).longValue();
    }

    @Nullable
    public <E extends T> E findById(long id, @NotNull Class<E> aClass) {
        return (E)((BambooObject)this.getCacheAwareHibernateTemplate().get(aClass, (Serializable)Long.valueOf(id)));
    }

    public long executeCountQuery(@NotNull String queryName) {
        return ((Number)this.getCacheAwareHibernateTemplate().execute(session -> (Number)session.getNamedQuery(queryName).uniqueResult())).longValue();
    }

    protected String convertSearchTermToLikeExpression(@Nullable String searchTerm) {
        return (searchTerm = StringUtils.trimToNull((String)searchTerm)) != null ? "%" + searchTerm.toLowerCase().replace("*", "%").replace("?", "_") + "%" : null;
    }
}

