/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence3;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.versioning.Versionable;
import com.atlassian.bamboo.versioning.VersionedEntityComponent;
import com.atlassian.bamboo.versioning.VersioningSupplement;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public abstract class BambooHibernateVersionAwareObjectDao<T extends BambooObject, R>
extends BambooHibernateObjectDao<T> {
    @Override
    public void save(@NotNull T t) {
        super.save(t);
        this.incrementMainVersion(t);
        this.incrementRootVersion(t);
    }

    @Override
    public <E extends T> void saveAll(@NotNull Collection<E> entities) {
        super.saveAll(entities);
        this.incrementMainVersion(entities);
        this.incrementRootVersion(entities);
    }

    @Override
    public void delete(@NotNull T t) {
        this.incrementRootVersion(t);
        super.delete(t);
    }

    @Override
    public <E extends T> void deleteAll(@NotNull Collection<E> entities) {
        this.incrementRootVersion(entities);
        super.deleteAll(entities);
    }

    @NotNull
    protected Optional<VersioningSupplement<T>> getMainVersioningSupplement() {
        return Optional.empty();
    }

    @NotNull
    protected Optional<VersioningSupplement<R>> getRootVersioningSupplement() {
        return Optional.empty();
    }

    protected void incrementMainVersion(@NotNull T entity) {
        Optional versioningSupplement = this.getMainVersioningSupplement();
        if (versioningSupplement.isEmpty()) {
            return;
        }
        Versionable versionable = (Versionable)Narrow.downTo(entity, Versionable.class);
        if (versionable != null) {
            this.getCacheAwareHibernateTemplate().execute(session -> {
                versioningSupplement.ifPresent(vs -> vs.incrementVersion(entity, session));
                return null;
            });
        }
    }

    protected <E extends T> void incrementMainVersion(@NotNull Collection<E> entities) {
        Optional versioningSupplement = this.getMainVersioningSupplement();
        if (versioningSupplement.isEmpty()) {
            return;
        }
        this.getCacheAwareHibernateTemplate().execute(session -> {
            entities.forEach(entity -> {
                Versionable versionable = (Versionable)Narrow.downTo((Object)entity, Versionable.class);
                if (versionable != null) {
                    versioningSupplement.ifPresent(vs -> vs.incrementVersion(entity, session));
                }
            });
            return null;
        });
    }

    protected void incrementRootVersion(@NotNull T entity) {
        Optional versioningSupplement = this.getRootVersioningSupplement();
        if (versioningSupplement.isEmpty()) {
            return;
        }
        try {
            VersionedEntityComponent versionedEntityComponent = (VersionedEntityComponent)Narrow.downTo(entity, VersionedEntityComponent.class);
            if (versionedEntityComponent != null) {
                this.getCacheAwareHibernateTemplate().execute(session -> {
                    versioningSupplement.ifPresent(vs -> vs.incrementVersion(versionedEntityComponent.getRoot(), session));
                    return null;
                });
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected <E extends T> void incrementRootVersion(@NotNull Collection<E> entities) {
        Optional versioningSupplement = this.getRootVersioningSupplement();
        if (versioningSupplement.isEmpty()) {
            return;
        }
        this.getCacheAwareHibernateTemplate().execute(session -> {
            entities.forEach(entity -> {
                try {
                    VersionedEntityComponent versionedEntityComponent = (VersionedEntityComponent)Narrow.downTo((Object)entity, VersionedEntityComponent.class);
                    if (versionedEntityComponent != null) {
                        versioningSupplement.ifPresent(vs -> vs.incrementVersion(versionedEntityComponent.getRoot(), session));
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            });
            return null;
        });
    }
}

