/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence3;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;
import org.jetbrains.annotations.NotNull;

public abstract class ConvertibleToLongUserType<T>
implements UserType,
Serializable {
    private final Class<T> objectClass;

    @NotNull
    public abstract T fromLong(long var1);

    public abstract long toLong(@NotNull T var1);

    protected ConvertibleToLongUserType(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public int[] sqlTypes() {
        return new int[]{-5};
    }

    public Class<T> returnedClass() {
        return this.objectClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equal((Object)x, (Object)y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Long longValue = rs.getLong(names[0]);
        return rs.wasNull() ? null : this.fromLong(longValue);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (this.objectClass.isInstance(value)) {
            st.setLong(index, this.toLong(this.objectClass.cast(value)));
        } else {
            st.setNull(index, -5);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public int hashCode(Object value) throws HibernateException {
        return value.hashCode();
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

