/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence3;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;
import org.jetbrains.annotations.NotNull;

public abstract class ConvertibleToStringUserType<T>
implements UserType,
Serializable {
    private final Class<T> objectClass;

    protected ConvertibleToStringUserType(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class<T> returnedClass() {
        return this.objectClass;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equal((Object)x, (Object)y);
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String stringValue = resultSet.getString(names[0]);
        if (resultSet.wasNull()) {
            return null;
        }
        return this.fromString(stringValue);
    }

    public abstract T fromString(@NotNull String var1);

    public String toString(@NotNull T object) {
        return object.toString();
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 12);
        } else if (this.objectClass.isAssignableFrom(value.getClass())) {
            preparedStatement.setString(index, this.toString(this.objectClass.cast(value)));
        } else {
            preparedStatement.setString(index, value.toString());
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

