/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persistence3;

import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persistence.ImportAwareGenerator;
import com.atlassian.bamboo.persistence3.StatelessSessionHibernateDaoSupport;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.type.DbTimestampType;
import org.hibernate.type.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateOperations;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class HibernateDaoUtils {
    private static final Logger log = Logger.getLogger(HibernateDaoUtils.class);
    public static final int ORACLE_MAXIMUM_NUMBER_OF_VALUES_FOR_IN_QUERY = 1000;

    private HibernateDaoUtils() {
    }

    public static void updateTimestamp(BambooObject bambooObject) {
        EntityObject objectToSave = (EntityObject)Narrow.reinterpret((Object)bambooObject, EntityObject.class);
        if (objectToSave == null) {
            return;
        }
        Date date = objectToSave.getCurrentDate();
        objectToSave.setLastModificationDate(date);
        if (objectToSave.getCreationDate() == null) {
            objectToSave.setCreationDate(date);
        }
    }

    public static void copyTimestamp(BambooObject from, BambooObject to) {
        EntityObject entityObjectFrom = (EntityObject)Narrow.reinterpret((Object)from, EntityObject.class);
        EntityObject entityObjectTo = (EntityObject)Narrow.reinterpret((Object)to, EntityObject.class);
        if (entityObjectFrom != null && entityObjectTo != null) {
            entityObjectTo.setCreationDate(entityObjectFrom.getCreationDate());
            entityObjectTo.setLastModificationDate(entityObjectFrom.getLastModificationDate());
        }
    }

    @Deprecated
    public static void saveOrUpdate(@NotNull HibernateDaoSupport dao, final BambooObject entity) {
        HibernateTemplate hibernateTemplate = HibernateDaoUtils.getHibernateTemplate(dao);
        hibernateTemplate.execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateDaoUtils.saveOrUpdate(session, entity);
                return null;
            }
        });
    }

    public static void saveOrUpdate(@NotNull Session session, BambooObject entity) {
        HibernateDaoUtils.updateTimestamp(entity);
        session.saveOrUpdate((Object)entity);
    }

    @Deprecated
    public static void saveAll(@NotNull HibernateDaoSupport dao, final Collection<? extends BambooObject> entities) {
        entities.forEach(HibernateDaoUtils::updateTimestamp);
        HibernateTemplate hibernateTemplate = HibernateDaoUtils.getHibernateTemplate(dao);
        hibernateTemplate.execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateDaoUtils.saveOrUpdateAll(session, entities);
                return null;
            }
        });
    }

    public static void saveOrUpdateAll(Session session, @NotNull Iterable<?> entities) {
        for (Object entity : entities) {
            session.saveOrUpdate(entity);
        }
    }

    @Deprecated
    public static void saveOrUpdateAll(HibernateOperations hibernateTemplate, final Iterable<?> entities) throws DataAccessException {
        hibernateTemplate.execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateDaoUtils.saveOrUpdateAll(session, entities);
                return null;
            }
        });
    }

    @Deprecated
    @Nullable
    public static <E extends BambooObject> E execute(@NotNull HibernateDaoSupport dao, @NotNull HibernateCallback action) throws DataAccessException {
        return (E)((BambooObject)HibernateDaoUtils.getHibernateTemplate(dao).execute(action));
    }

    @Deprecated
    public static boolean exists(@NotNull HibernateDaoSupport dao, @NotNull HibernateCallback action) throws DataAccessException {
        return (Boolean)HibernateDaoUtils.getHibernateTemplate(dao).execute(action);
    }

    @Deprecated
    public static void save(HibernateOperations hibernateOperations, final Object object, final Serializable id) {
        hibernateOperations.execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                HibernateDaoUtils.save(session, object, id);
                return null;
            }
        });
    }

    @Deprecated
    public static void save(Session session, Object object, Serializable id) {
        ImportAwareGenerator.enterSaveWithIdContext(object, id);
        try {
            session.save(object);
        }
        finally {
            ImportAwareGenerator.leaveSaveWithIdContext();
        }
    }

    public static void deleteAll(Session session, List entities) {
        entities.forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    @Deprecated
    public static <T extends BambooObject> Function<T, T> saveOrUpdateFunction(@NotNull HibernateTemplate hibernateTemplate) {
        return new SaveOrUpdateBambooObjectFunction(hibernateTemplate);
    }

    public static void bindQueryParameters(@NotNull Query query, @NotNull Map<String, Object> params) throws HibernateException {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() instanceof Collection) {
                query.setParameterList(entry.getKey(), (Collection)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Date) {
                query.setParameter(entry.getKey(), entry.getValue(), (Type)DbTimestampType.INSTANCE);
                continue;
            }
            query.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public static void addRestrictionIn(DbmsBean dbmsBean, Criteria criteria, String propertyName, List<?> values) {
        int maximumNumberOfValuesForIn = HibernateDaoUtils.getMaximumNumberOfValuesForIn(dbmsBean);
        if (values.size() <= maximumNumberOfValuesForIn) {
            criteria.add(Restrictions.in((String)propertyName, values));
        } else {
            log.debug((Object)("Adding disjunctions to " + criteria + ", clauses: " + values.size()));
            Disjunction or = Restrictions.disjunction();
            for (List partition : Lists.partition(values, (int)maximumNumberOfValuesForIn)) {
                or.add(Restrictions.in((String)propertyName, (Collection)partition));
            }
            criteria.add((Criterion)or);
        }
    }

    public static List listCriteria(DbmsBean dbmsBean, Supplier<Criteria> criteriaFactory, String propertyName, List<?> values) {
        int maximumNumberOfValuesForIn = HibernateDaoUtils.getMaximumNumberOfValuesForIn(dbmsBean);
        if (values.size() <= maximumNumberOfValuesForIn) {
            Criteria criteria = criteriaFactory.get().add(Restrictions.in((String)propertyName, values));
            return criteria.list();
        }
        if (dbmsBean.isMsSqlServer()) {
            log.debug((Object)("Running partitioned criteria query, clauses: " + values.size()));
            ArrayList result = new ArrayList();
            for (List partition : Lists.partition(values, (int)maximumNumberOfValuesForIn)) {
                Criteria criteria = criteriaFactory.get().add(Restrictions.in((String)propertyName, (Collection)partition));
                result.addAll(criteria.list());
            }
            return result;
        }
        Criteria criteria = criteriaFactory.get();
        HibernateDaoUtils.addRestrictionIn(dbmsBean, criteria, propertyName, values);
        return criteria.list();
    }

    public static List listQuery(DbmsBean dbmsBean, Query query, String queryParam, List<?> values) {
        int maximumNumberOfValuesForIn = HibernateDaoUtils.getMaximumNumberOfValuesForIn(dbmsBean);
        if (values.size() <= maximumNumberOfValuesForIn) {
            query.setParameterList(queryParam, values);
            return query.list();
        }
        log.debug((Object)("Running split queries for list of " + values.size() + " items"));
        ArrayList result = new ArrayList();
        for (List partition : Lists.partition(values, (int)maximumNumberOfValuesForIn)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Running query: %s\nwith param %s = %s", query.getQueryString(), queryParam, partition));
            }
            query.setParameterList(queryParam, (Collection)partition);
            result.addAll(query.list());
        }
        return result;
    }

    public static List listQuery(DbmsBean dbmsBean, Query query, String queryParam1, List<?> values1, String queryParam2, List<?> values2) {
        int maximumNumberOfValuesForIn = HibernateDaoUtils.getMaximumNumberOfValuesForIn(dbmsBean);
        if (values1.size() <= maximumNumberOfValuesForIn && values2.size() <= maximumNumberOfValuesForIn) {
            query.setParameterList(queryParam1, values1);
            query.setParameterList(queryParam2, values2);
            return query.list();
        }
        log.debug((Object)("Running split queries for list of " + values1.size() + " items"));
        ArrayList result = new ArrayList();
        for (List partition1 : Lists.partition(values1, (int)maximumNumberOfValuesForIn)) {
            for (List partition2 : Lists.partition(values2, (int)maximumNumberOfValuesForIn)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Running query: %s\nwith param %s = %s and param %s = %s", query.getQueryString(), queryParam1, partition1, queryParam2, partition2));
                }
                query.setParameterList(queryParam1, (Collection)partition1);
                query.setParameterList(queryParam2, (Collection)partition2);
                result.addAll(query.list());
            }
        }
        return result;
    }

    public static int getMaximumNumberOfValuesForIn(DbmsBean dbmsBean) {
        return switch (dbmsBean.getDatabaseType()) {
            case DatabaseType.ORACLE -> 1000;
            case DatabaseType.MSSQL -> 1900;
            default -> Integer.MAX_VALUE;
        };
    }

    private static HibernateTemplate getHibernateTemplate(@NotNull HibernateDaoSupport dao) {
        StatelessSessionHibernateDaoSupport sshds = (StatelessSessionHibernateDaoSupport)((Object)Narrow.downTo((Object)dao, StatelessSessionHibernateDaoSupport.class));
        if (sshds != null) {
            return sshds.getCacheAwareHibernateTemplate();
        }
        return dao.getHibernateTemplate();
    }

    public static <T extends EntityObject> T setId(T bambooObject, long id) {
        bambooObject.setId(id);
        return bambooObject;
    }

    private static class SaveOrUpdateBambooObjectFunction<T extends BambooObject>
    implements Function<T, T> {
        private final HibernateTemplate hibernateTemplate;

        private SaveOrUpdateBambooObjectFunction(HibernateTemplate hibernateTemplate) {
            this.hibernateTemplate = hibernateTemplate;
        }

        public BambooObject apply(@Nullable BambooObject bambooObject) {
            HibernateDaoUtils.updateTimestamp(bambooObject);
            this.hibernateTemplate.saveOrUpdate((Object)bambooObject);
            return bambooObject;
        }
    }
}

