/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.hibernate.callbacks.ScrollHibernateCallback;
import com.atlassian.bamboo.jpa.JpaUtils;
import com.atlassian.bamboo.persistence3.BambooHibernateObjectDao;
import com.atlassian.bamboo.persister.AuditLogDao;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.persister.AuditLogMessage;
import com.atlassian.bamboo.persister.AuditLogMessage_;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class AuditLogHibernateDao
extends BambooHibernateObjectDao<AuditLogEntry>
implements AuditLogDao {
    private static final Class<AuditLogMessage> PERSISTENT_CLASS = AuditLogMessage.class;

    public List<AuditLogEntry> getAuditLogMessagesForEntity(@NotNull String entityId, @Nullable AuditLogEntityType entityType, long startDate, long endDate, int firstResult, int maxResults) {
        return this.getAuditLogMessagesForEntity(entityId, entityType, startDate, endDate, firstResult, maxResults, null);
    }

    public List<AuditLogEntry> getAuditLogMessagesForEntity(final @NotNull String entityId, final @Nullable AuditLogEntityType entityType, final long startDate, final long endDate, int firstResult, int maxResults, final @Nullable String searchTerm) {
        return new JpaUtils.CriteriaQuery<AuditLogMessage, AuditLogEntry>(this.getSessionFactory(), PERSISTENT_CLASS, AuditLogEntry.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.desc((Expression)this.entity.get(AuditLogMessage_.timestamp))});
                AuditLogHibernateDao.this.prepareDefaultPredicates(this.cb, (Root<? extends AuditLogMessage>)this.entity, entityId, entityType, startDate, endDate, searchTerm, this.q);
            }
        }.getResultList(firstResult, maxResults);
    }

    public long countAuditLogMessagesForEntity(@NotNull String entityId, AuditLogEntityType entityType, long startDate, long endDate) {
        return this.countAuditLogMessagesForEntity(entityId, entityType, startDate, endDate, null);
    }

    public long countAuditLogMessagesForEntity(final @NotNull String entityId, final @Nullable AuditLogEntityType entityType, final long startDate, final long endDate, final @Nullable String searchTerm) {
        return (Long)new JpaUtils.CriteriaQuery<AuditLogMessage, Long>(this.getSessionFactory(), PERSISTENT_CLASS, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity));
                AuditLogHibernateDao.this.prepareDefaultPredicates(this.cb, (Root<? extends AuditLogMessage>)this.entity, entityId, entityType, startDate, endDate, searchTerm, this.q);
            }
        }.getSingleResult();
    }

    public List<AuditLogEntry> getGlobalAuditLogMessages() {
        return this.getGlobalAuditLogMessages(-1, -1);
    }

    public List<AuditLogEntry> getGlobalAuditLogMessages(int firstResult, int maxResults) {
        return this.getGlobalAuditLogMessages(firstResult, maxResults, null);
    }

    public List<AuditLogEntry> getGlobalAuditLogMessages(int firstResult, int maxResults, final @Nullable String searchTerm) {
        return new JpaUtils.CriteriaQuery<AuditLogMessage, AuditLogEntry>(this.getSessionFactory(), PERSISTENT_CLASS, AuditLogEntry.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.desc((Expression)this.entity.get(AuditLogMessage_.timestamp))});
                AuditLogHibernateDao.this.prepareGlobalPredicates(this.cb, (Root<? extends AuditLogMessage>)this.entity, searchTerm, this.q);
            }
        }.getResultList(firstResult, maxResults);
    }

    public long countGlobalAuditLogMessages() {
        return this.countGlobalAuditLogMessages(null);
    }

    public long countGlobalAuditLogMessages(final @Nullable String searchTerm) {
        return (Long)new JpaUtils.CriteriaQuery<AuditLogMessage, Long>(this.getSessionFactory(), PERSISTENT_CLASS, Long.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.cb.count((Expression)this.entity));
                AuditLogHibernateDao.this.prepareGlobalPredicates(this.cb, (Root<? extends AuditLogMessage>)this.entity, searchTerm, this.q);
            }
        }.getSingleResult();
    }

    public List<AuditLogEntry> getAgentAuditLogsMessagesByAgentName(@NotNull String agentName) {
        return this.getAgentAuditLogsMessagesByAgentName(agentName, null);
    }

    public List<AuditLogEntry> getAgentAuditLogsMessagesByAgentName(final String agentName, final @Nullable String searchTerm) {
        return new JpaUtils.CriteriaQuery<AuditLogMessage, AuditLogEntry>(this.getSessionFactory(), PERSISTENT_CLASS, AuditLogEntry.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.desc((Expression)this.entity.get(AuditLogMessage_.timestamp))});
                AuditLogHibernateDao.this.prepareAgentPredicates(this.cb, (Root<? extends AuditLogMessage>)this.entity, agentName, searchTerm, this.q);
            }
        }.getResultList();
    }

    @Deprecated
    public List<AuditLogEntry> getAuditLogMessagesForPlan(final ImmutablePlan plan, final long startDate, final long endDate, int firstResult, int maxResults) {
        return new JpaUtils.CriteriaQuery<AuditLogMessage, AuditLogEntry>(this.getSessionFactory(), PERSISTENT_CLASS, AuditLogEntry.class){

            @Override
            public void apply() {
                this.q.select((Selection)this.entity).orderBy(new Order[]{this.cb.desc((Expression)this.entity.get(AuditLogMessage_.timestamp))});
                JpaUtils.accumulator().add(AuditLogHibernateDao.this.planOrJobPredicate(this.cb, (Root<? extends AuditLogMessage>)this.entity, plan)).add(AuditLogHibernateDao.this.startAndEndDatePredicates(this.cb, (Root<? extends AuditLogMessage>)this.entity, startDate, endDate)).toWhere(this.q);
            }
        }.getResultList(firstResult, maxResults);
    }

    public void deleteAllAuditLogMessages() {
        new JpaUtils.CriteriaDelete<AuditLogMessage>(this.getSessionFactory(), AuditLogMessage.class){

            @Override
            public void apply() {
            }
        }.executeUpdate();
    }

    public void deleteAuditLogMessagesByTypeAndEntityId(final String entityId, final AuditLogEntityType entityType) {
        new JpaUtils.CriteriaDelete<AuditLogMessage>(this.getSessionFactory(), AuditLogMessage.class){

            @Override
            public void apply() {
                this.delete.where(AuditLogHibernateDao.this.entityPredicate(this.cb, (Root<? extends AuditLogMessage>)this.entity, entityId, entityType).toArray(new Predicate[0]));
            }
        }.executeUpdate();
    }

    @NotNull
    public Collection<? extends AuditLogEntry> findAll() {
        return this.findAll(PERSISTENT_CLASS);
    }

    public long scrollAuditLogsForExport(final Consumer<AuditLogEntry> consumer) {
        Long countOfAuditLogsForExport = (Long)this.getCacheAwareHibernateTemplate().execute((HibernateCallback)new ScrollHibernateCallback(){

            @Override
            @NotNull
            public Query configureQuery(@NotNull Session session) throws HibernateException {
                return session.getNamedQuery("auditLogsForExport");
            }

            @Override
            public void nextScrollableResult(@NotNull Session session, @NotNull ScrollableResults data) throws HibernateException {
                AuditLogMessage auditLogEntry = new AuditLogMessage();
                auditLogEntry.setId(data.getLong(0).longValue());
                auditLogEntry.setEntityId(data.getString(1));
                auditLogEntry.setChildId(data.getString(2));
                auditLogEntry.setTimestamp(data.getLong(3));
                auditLogEntry.setMessage(data.getString(4));
                auditLogEntry.setOldValue(data.getString(5));
                auditLogEntry.setNewValue(data.getString(6));
                auditLogEntry.setMessageType(data.getString(7));
                auditLogEntry.setFieldHeader(data.getString(8));
                auditLogEntry.setEntityType((AuditLogEntityType)data.get(9));
                auditLogEntry.setUsername(data.getString(10));
                auditLogEntry.setFieldType((AuditLogEntityType)data.get(11));
                consumer.accept(auditLogEntry);
            }
        });
        return countOfAuditLogsForExport == null ? 0L : countOfAuditLogsForExport;
    }

    private List<Predicate> startAndEndDatePredicates(CriteriaBuilder cb, Root<? extends AuditLogMessage> msg, long startDate, long endDate) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (startDate > 0L) {
            predicates.add(cb.ge((Expression)msg.get(AuditLogMessage_.timestamp), (Number)startDate));
        }
        if (endDate > 0L) {
            predicates.add(cb.le((Expression)msg.get(AuditLogMessage_.timestamp), (Number)endDate));
        }
        return predicates;
    }

    private Predicate planOrJobPredicate(CriteriaBuilder cb, Root<? extends AuditLogMessage> msg, @NotNull ImmutablePlan plan) {
        SingularAttribute attr = PlanClassHelper.isJob((ImmutablePlan)plan) ? AuditLogMessage_.childId : AuditLogMessage_.entityId;
        return cb.equal((Expression)msg.get(attr), (Object)plan.getPlanKey().getKey());
    }

    private List<Predicate> entityPredicate(CriteriaBuilder cb, Root<? extends AuditLogMessage> msg, @NotNull String entityId, @Nullable AuditLogEntityType entityType) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        SingularAttribute attr = AuditLogMessage_.entityId;
        predicates.add(cb.equal((Expression)msg.get(attr), (Object)entityId));
        if (entityType != null) {
            predicates.add(cb.equal((Expression)msg.get(AuditLogMessage_.entityType), (Object)entityType));
        }
        return predicates;
    }

    private <R> void prepareDefaultPredicates(CriteriaBuilder cb, Root<? extends AuditLogMessage> entity, @NotNull String entityId, @Nullable AuditLogEntityType entityType, long startDate, long endDate, String searchTerm, CriteriaQuery<R> q) {
        JpaUtils.accumulator().add(this.entityPredicate(cb, entity, entityId, entityType)).add(this.startAndEndDatePredicates(cb, entity, startDate, endDate)).add(this.prepareDefaultSearchTermPredicate(cb, entity, searchTerm)).toWhere(q);
    }

    private <R> void prepareGlobalPredicates(CriteriaBuilder cb, Root<? extends AuditLogMessage> entity, String searchTerm, CriteriaQuery<R> q) {
        JpaUtils.accumulator().add(cb.isNull((Expression)entity.get(AuditLogMessage_.entityId))).add(this.prepareDefaultSearchTermPredicate(cb, entity, searchTerm)).toWhere(q);
    }

    private <R> void prepareAgentPredicates(CriteriaBuilder cb, Root<? extends AuditLogMessage> entity, String agentName, String searchTerm, CriteriaQuery<R> q) {
        JpaUtils.accumulator().add(cb.isNull((Expression)entity.get(AuditLogMessage_.entityId))).add(cb.like((Expression)entity.get(AuditLogMessage_.message), "%" + agentName + "%")).add(this.prepareDefaultSearchTermPredicate(cb, entity, searchTerm)).toWhere(q);
    }

    private List<Predicate> prepareDefaultSearchTermPredicate(CriteriaBuilder cb, Root<? extends AuditLogMessage> entity, String searchTerm) {
        String convertedSearchExpression = this.convertSearchTermToLikeExpression(searchTerm);
        return StringUtils.isNotBlank((CharSequence)searchTerm) ? Collections.singletonList(cb.or(new Predicate[]{cb.like(cb.lower((Expression)entity.get(AuditLogMessage_.message)), convertedSearchExpression), cb.like(cb.lower((Expression)entity.get(AuditLogMessage_.oldValue)), convertedSearchExpression), cb.like(cb.lower((Expression)entity.get(AuditLogMessage_.newValue)), convertedSearchExpression), cb.like(cb.lower((Expression)entity.get(AuditLogMessage_.username)), convertedSearchExpression)})) : Collections.emptyList();
    }
}

