/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildDefinitionXml;
import com.atlassian.bamboo.deployments.configuration.persistence.EnvironmentCustomConfig;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.XmlDiffFinder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;

class AuditLogTxSync
extends TransactionSynchronizationAdapter {
    private static final Logger log = Logger.getLogger(AuditLogTxSync.class);
    private static final Set<String> INTERESTING_PLAN_FIELDS = Sets.newHashSet((Object[])new String[]{"suspendedFromBuilding", "buildName", "description"});
    private static final Set<String> BORING_ENVIRONMENT_FIELDS = Sets.newHashSet((Object[])new String[]{"configurationState", "tasksXmlData", "triggersXmlData"});
    private static final Set<String> IGNORE_PREFIXES = ImmutableSet.of((Object)"buildStrategies.", (Object)"buildTasks.", (Object)"triggers.", (Object)ConfigUtils.BAMBOO_DELIMITER_PARSING_DISABLED, (Object)"[@xml:space]");
    private final Map<Serializable, Map<String, Pair<Object, Object>>> changesMap = new HashMap<Serializable, Map<String, Pair<Object, Object>>>();
    private final Map<Serializable, Runnable> afterCommitHandlers = new HashMap<Serializable, Runnable>();
    private final Set<AuditLogRequest> auditLogMessages = new LinkedHashSet<AuditLogRequest>();
    private final AuditLogService auditLogService;
    private int counter = 0;

    public AuditLogTxSync(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    public void afterCompletion(int status) {
        this.afterCommitHandlers.clear();
        this.changesMap.clear();
        this.auditLogMessages.clear();
    }

    public void afterCommit() {
        if (++this.counter >= 2) {
            log.fatal((Object)"After commit triggered more than once");
        }
        this.afterCommitHandlers.values().forEach(Runnable::run);
        this.afterCommitHandlers.clear();
        this.changesMap.clear();
        try {
            if (this.auditLogService.isEnabled()) {
                for (AuditLogRequest auditLogRequest : this.auditLogMessages) {
                    this.auditLogService.log(Collections.singletonList(auditLogRequest.getFieldChange()), auditLogRequest.getEntityId(), auditLogRequest.getEntityType(), auditLogRequest.getChildId(), auditLogRequest.getEntity());
                }
            }
        }
        finally {
            this.auditLogMessages.clear();
        }
    }

    public void addChanges(@NotNull Serializable id, @NotNull Object entity, @NotNull Object[] currentState, @NotNull Object[] previousState, @NotNull String[] propertyNames) {
        Set<String> interestingFields = null;
        Set<String> boringFields = null;
        if (entity instanceof ImmutablePlan) {
            interestingFields = INTERESTING_PLAN_FIELDS;
        } else if (entity instanceof MutableEnvironment) {
            boringFields = BORING_ENVIRONMENT_FIELDS;
        }
        boolean allFieldsExceptBoringAreInteresting = CollectionUtils.isEmpty(interestingFields);
        Map changes = this.changesMap.computeIfAbsent(id, x -> new HashMap());
        for (int i = 0; i < propertyNames.length; ++i) {
            boolean isInteresting;
            String propertyName = propertyNames[i];
            if (BambooCollectionUtils.contains(boringFields, (Object)propertyName)) continue;
            boolean bl = isInteresting = allFieldsExceptBoringAreInteresting || interestingFields.contains(propertyName);
            if (!isInteresting) continue;
            Pair existingPair = (Pair)changes.get(propertyName);
            if (existingPair == null && (this.isBuildConfigPlanField(entity, propertyName) || !Objects.equals(previousState[i], currentState[i]))) {
                changes.put(propertyName, Pair.make((Object)previousState[i], (Object)currentState[i]));
                continue;
            }
            if (existingPair == null) continue;
            changes.put(propertyName, Pair.make((Object)existingPair.getFirst(), (Object)currentState[i]));
        }
    }

    private boolean isBuildConfigPlanField(Object entity, String propertyName) {
        return entity instanceof BuildDefinitionXml && "plan".equals(propertyName);
    }

    public void registerPostCommitAction(@NotNull Serializable id, @NotNull Runnable runnable) {
        this.afterCommitHandlers.put(id, runnable);
    }

    public Runnable createAuditLogRequestsRunnable(@NotNull Serializable id, Object entity) {
        return () -> {
            try {
                if (!this.changesMap.containsKey(id)) {
                    return;
                }
                Map<String, Pair<Object, Object>> collectedChanges = this.changesMap.get(id);
                if (entity instanceof ImmutablePlan) {
                    this.logPlanChanges((ImmutablePlan)entity, collectedChanges);
                } else if (entity instanceof BuildDefinitionXml) {
                    this.logBuildDefinitionChanges(collectedChanges);
                } else if (entity instanceof ElasticImageConfiguration) {
                    String configurationName = ((ElasticImageConfiguration)entity).getConfigurationName();
                    this.logEntityChanges(collectedChanges, new AuditLogEntity(AuditLogEntityType.IMAGE_CONFIG, configurationName));
                } else if (entity instanceof MutableDeploymentProject) {
                    Collection<AuditLogService.FieldChange> changes = AuditLogTxSync.getChanges(collectedChanges, null, null);
                    this.addAuditLogRequestsFromChanges(changes, AuditLogEntityType.DEPLOYMENT_PROJECT, String.valueOf(((MutableDeploymentProject)entity).getId()), null, null);
                } else if (entity instanceof MutableEnvironment) {
                    Collection<AuditLogService.FieldChange> changes = AuditLogTxSync.getChanges(collectedChanges, null, BORING_ENVIRONMENT_FIELDS);
                    MutableEnvironment environment = (MutableEnvironment)entity;
                    MutableDeploymentProject deploymentProject = environment.getDeploymentProject();
                    this.addAuditLogRequestsFromChanges(changes, AuditLogEntityType.DEPLOYMENT_PROJECT, String.valueOf(deploymentProject.getId()), String.valueOf(environment.getId()), new AuditLogEntity(AuditLogEntityType.DEPLOYMENT_PROJECT, "Environment"));
                } else if (entity instanceof EnvironmentCustomConfig) {
                    EnvironmentCustomConfig environmentCustomConfig = (EnvironmentCustomConfig)entity;
                    Collection<AuditLogService.FieldChange> changes = AuditLogTxSync.getChanges(collectedChanges, null, null);
                    this.addAuditLogRequestsFromChanges(changes, AuditLogEntityType.DEPLOYMENT_PROJECT, String.valueOf(environmentCustomConfig.getEnvironment().getDeploymentProjectId()), String.valueOf(environmentCustomConfig.getEnvironment().getId()), null);
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"Error while trying to record configuration changes", (Throwable)e);
                throw e;
            }
        };
    }

    private void addAuditLogRequestsFromChanges(Iterable<AuditLogService.FieldChange> changes, AuditLogEntityType entityType, String entityId, String childId, AuditLogEntity entity) {
        BambooIterables.stream(changes).map(c -> new AuditLogRequest(entityType, (AuditLogService.FieldChange)c, entityId, childId, entity)).forEach(this.auditLogMessages::add);
    }

    private void logBuildDefinitionChanges(@NotNull Map<String, Pair<Object, Object>> collectedChanges) {
        ImmutablePlan plan = null;
        Collection changes = null;
        for (Map.Entry<String, Pair<Object, Object>> entry : collectedChanges.entrySet()) {
            if ("xmlData".equals(entry.getKey()) && !Objects.equals(entry.getValue().getFirst(), entry.getValue().getSecond())) {
                XmlDiffFinder xmlDiffFinder = new XmlDiffFinder((String)entry.getValue().getFirst(), (String)entry.getValue().getSecond());
                changes = Collections2.filter((Collection)xmlDiffFinder.findChanges(), input -> {
                    String fieldName = input.getFieldName();
                    return IGNORE_PREFIXES.stream().noneMatch(fieldName::startsWith);
                });
            }
            if (!"plan".equals(entry.getKey())) continue;
            plan = (ImmutablePlan)entry.getValue().getSecond();
        }
        if (changes == null) {
            return;
        }
        if (plan != null) {
            PlanKey chainKeyIfJobKey = PlanKeys.getChainKeyIfJobKey((PlanKey)plan.getPlanKey());
            this.addAuditLogRequestsFromChanges(changes, AuditLogEntityType.PLAN, chainKeyIfJobKey != null ? chainKeyIfJobKey.getKey() : plan.getPlanKey().getKey(), chainKeyIfJobKey != null ? plan.getPlanKey().getKey() : null, null);
        } else {
            log.warn((Object)"Bamboo audit log interceptor found changes in a build configuration object but could not identify the plan it belongs to.");
        }
    }

    private void logPlanChanges(@NotNull ImmutablePlan plan, @NotNull Map<String, Pair<Object, Object>> collectedChanges) {
        Collection<AuditLogService.FieldChange> changes = AuditLogTxSync.getChanges(collectedChanges, INTERESTING_PLAN_FIELDS, null);
        PlanKey chainKeyIfJobKey = PlanKeys.getChainKeyIfJobKey((PlanKey)plan.getPlanKey());
        Set<AuditLogRequest> auditLogRequests = this.auditLogMessages;
        if (chainKeyIfJobKey == null) {
            this.addAuditLogRequestsFromChanges(changes, AuditLogEntityType.PLAN, plan.getPlanKey().getKey(), null, null);
        } else {
            this.addAuditLogRequestsFromChanges(changes, AuditLogEntityType.PLAN, chainKeyIfJobKey.getKey(), plan.getPlanKey().getKey(), null);
        }
    }

    private void logEntityChanges(@NotNull Map<String, Pair<Object, Object>> collectedChanges, @Nullable AuditLogEntity auditLogEntityType) {
        Collection<AuditLogService.FieldChange> changes = AuditLogTxSync.getChanges(collectedChanges, null, null);
        this.addAuditLogRequestsFromChanges(changes, auditLogEntityType != null ? auditLogEntityType.getType() : null, null, null, auditLogEntityType);
    }

    @VisibleForTesting
    static Collection<AuditLogService.FieldChange> getChanges(@NotNull Map<String, Pair<Object, Object>> collectedChanges, @Nullable Set<String> interestingFields, @Nullable Set<String> boringFields) {
        boolean allFieldsExceptBoringAreInteresting = CollectionUtils.isEmpty(interestingFields);
        ArrayList<AuditLogService.FieldChange> changes = new ArrayList<AuditLogService.FieldChange>(collectedChanges.size());
        for (Map.Entry<String, Pair<Object, Object>> change : collectedChanges.entrySet()) {
            boolean isInteresting;
            String propertyName = change.getKey();
            if (BambooCollectionUtils.contains(boringFields, (Object)propertyName) || !(isInteresting = allFieldsExceptBoringAreInteresting || interestingFields.contains(propertyName)) || Objects.equals(change.getValue().getFirst(), change.getValue().getSecond())) continue;
            String oldValue = ObjectUtils.defaultIfNull((Object)change.getValue().getFirst(), (Object)"").toString();
            String newValue = ObjectUtils.defaultIfNull((Object)change.getValue().getSecond(), (Object)"").toString();
            changes.add((AuditLogService.FieldChange)new XmlDiffFinder.DefaultFieldChange(propertyName, oldValue, newValue));
        }
        return changes;
    }

    static class AuditLogRequest {
        private final AuditLogEntityType entityType;
        private final AuditLogService.FieldChange fieldChange;
        private final String entityId;
        private final String childId;
        private final AuditLogEntity entity;

        public AuditLogRequest(AuditLogEntityType entityType, AuditLogService.FieldChange fieldChange, String entityId, String childId, AuditLogEntity entity) {
            this.entityType = entityType;
            this.fieldChange = fieldChange;
            this.entityId = entityId;
            this.childId = childId;
            this.entity = entity;
        }

        public AuditLogEntityType getEntityType() {
            return this.entityType;
        }

        public AuditLogService.FieldChange getFieldChange() {
            return this.fieldChange;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getChildId() {
            return this.childId;
        }

        public AuditLogEntity getEntity() {
            return this.entity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuditLogRequest that = (AuditLogRequest)o;
            return this.getEntityType() == that.getEntityType() && Objects.equals(this.getEntityId(), that.getEntityId()) && Objects.equals(this.getChildId(), that.getChildId()) && Objects.equals(this.getFieldChange(), that.getFieldChange()) && Objects.equals(this.getEntity(), that.getEntity());
        }

        public int hashCode() {
            return Objects.hash(this.getEntityType(), this.getFieldChange(), this.getEntityId(), this.getChildId(), this.getEntity());
        }
    }
}

