/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.pipeline.concurrent.SystemAuthorityThreadFactory;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.persister.AuditLogDao;
import com.atlassian.bamboo.persister.AuditLogEntity;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.persister.AuditLogMessage;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.EncryptionService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.XmlDiffFinder;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultAuditLogService
implements AuditLogService {
    private static final Logger log = Logger.getLogger(DefaultAuditLogService.class);
    private static final String CONFIDENTIAL_FIELD_NAME = "confidential";
    private static final Set<String> OTHER_CONFIDENTIAL_FIELD_NAMES = ImmutableSet.of((Object)"key.private", (Object)"ssh.key", (Object)"sslKeyFile");
    private final AuditLogDao auditLogDao;
    private final BambooAuthenticationContext authenticationContext;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final ExecutorService executorService;
    private Boolean enabled;
    private final ThreadLocal<Boolean> isRssUpdatedLog = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public DefaultAuditLogService(AuditLogDao auditLogDao, BambooAuthenticationContext authenticationContext, AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister) {
        this.auditLogDao = auditLogDao;
        this.authenticationContext = authenticationContext;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new SystemAuthorityThreadFactory("AuditLogSaveThread"));
    }

    public void log(@NotNull AuditLogEntry msg) {
        if (this.isEnabled()) {
            this.executorService.submit(new LoggerRunnable(msg));
        }
    }

    public void log(@NotNull String msg) {
        this.log(this.authenticationContext.getUser(), msg);
    }

    public void log(@Nullable User user, @NotNull String msg) {
        AuditLogMessage logMessage = new AuditLogMessage(user == null ? null : user.getName(), new Date(), null, null, null, null, "CONFIG_CHANGE", msg, null, null);
        this.log((AuditLogEntry)logMessage);
    }

    public void log(@NotNull String msg, @Nullable Key key, AuditLogEntityType entityType) {
        this.log(this.authenticationContext.getUserName(), msg, key, entityType);
    }

    public void log(@NotNull String msg, @Nullable Key key, AuditLogEntityType entityType, @Nullable AuditLogEntity entity) {
        this.log(this.authenticationContext.getUserName(), msg, key, entityType, entity);
    }

    public void log(@Nullable User user, @NotNull String msg, @Nullable Key key, AuditLogEntityType entityType) {
        this.log(user == null ? null : user.getName(), msg, key, entityType);
    }

    public void log(@Nullable User user, @NotNull String msg, @Nullable Key key, AuditLogEntityType entityType, @Nullable AuditLogEntity entity) {
        this.log(user == null ? null : user.getName(), msg, key, entityType, entity);
    }

    public void log(@Nullable String username, @NotNull String msg, @Nullable Key key, AuditLogEntityType entityType) {
        EntityKeys entityKeys = new EntityKeys(key);
        AuditLogMessage logMessage = new AuditLogMessage(username, new Date(), entityType, entityKeys.getEntityId(), entityKeys.getChildId(), null, "CONFIG_CHANGE", msg, null, null);
        this.log((AuditLogEntry)logMessage);
    }

    public void log(@Nullable String username, @NotNull String msg, @Nullable Key key, @Nullable AuditLogEntityType entityType, @Nullable AuditLogEntity field) {
        EntityKeys entityKeys = new EntityKeys(key);
        AuditLogMessage logMessage = new AuditLogMessage(username, new Date(), entityType, entityKeys.getEntityId(), entityKeys.getChildId(), field, "CONFIG_CHANGE", msg, null, null);
        this.log((AuditLogEntry)logMessage);
    }

    public List<AuditLogEntry> getAuditLogMessagesForPlan(@NotNull ImmutablePlan plan, long startDate, long endDate, int firstResult, int maxResults) {
        return this.getAuditLogMessagesForEntity(plan.getKey(), AuditLogEntityType.PLAN, startDate, endDate, firstResult, maxResults);
    }

    public List<AuditLogEntry> getAuditLogMessagesForPlan(@NotNull ImmutablePlan plan, long startDate, long endDate, int firstResult, int maxResults, @Nullable String searchTerm) {
        return this.getAuditLogMessagesForEntity(plan.getKey(), AuditLogEntityType.PLAN, startDate, endDate, firstResult, maxResults, searchTerm);
    }

    public List<AuditLogEntry> getAuditLogMessagesForEntity(@NotNull String entityId, AuditLogEntityType entityType, long startDate, long endDate, int firstResult, int maxResults) {
        return this.auditLogDao.getAuditLogMessagesForEntity(entityId, entityType, startDate, endDate, firstResult, maxResults);
    }

    public List<AuditLogEntry> getAuditLogMessagesForEntity(@NotNull String entityId, @Nullable AuditLogEntityType entityType, long startDate, long endDate, int firstResult, int maxResults, @Nullable String searchTerm) {
        return this.auditLogDao.getAuditLogMessagesForEntity(entityId, entityType, startDate, endDate, firstResult, maxResults, searchTerm);
    }

    public boolean hasAuditLogMessagesForPlan(@NotNull ImmutablePlan plan, long startDate, long endDate) {
        return this.countAuditLogMessagesForPlan(plan, startDate, endDate) > 0L;
    }

    public void removeAuditLogMessagesForPlan(@NotNull ImmutablePlan plan) {
        this.removeAuditLogMessagesByTypeAndEntityId(plan.getKey(), AuditLogEntityType.PLAN);
    }

    public void removeAuditLogMessagesByTypeAndEntityId(@NotNull String entityId, @Nullable AuditLogEntityType entityType) {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        this.auditLogDao.deleteAuditLogMessagesByTypeAndEntityId(entityId, entityType);
    }

    public void removeGlobalAuditLogMessages() {
        this.auditLogDao.deleteAll((Collection)this.auditLogDao.getGlobalAuditLogMessages());
    }

    public void removeAllAuditLogMessages() {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        this.auditLogDao.deleteAllAuditLogMessages();
    }

    public List<AuditLogEntry> getGlobalAuditLogMessages(int firstResult, int maxResults) {
        return this.auditLogDao.getGlobalAuditLogMessages(firstResult, maxResults);
    }

    public List<AuditLogEntry> getGlobalAuditLogMessages(int firstResult, int maxResults, @Nullable String searchTerm) {
        return this.auditLogDao.getGlobalAuditLogMessages(firstResult, maxResults, searchTerm);
    }

    public long countGlobalAuditLogMessages() {
        return this.auditLogDao.countGlobalAuditLogMessages();
    }

    public long countGlobalAuditLogMessages(@Nullable String searchTerm) {
        return this.auditLogDao.countGlobalAuditLogMessages(searchTerm);
    }

    public long countAuditLogMessagesForPlan(@NotNull ImmutablePlan plan) {
        return this.countAuditLogMessagesForPlan(plan, 0L, 0L);
    }

    public long countAuditLogMessagesForPlan(@NotNull ImmutablePlan plan, long startDate, long endDate) {
        return this.countAuditLogMessagesForEntity(plan.getKey(), AuditLogEntityType.PLAN, startDate, endDate);
    }

    public long countAuditLogMessagesForPlan(@NotNull ImmutablePlan plan, long startDate, long endDate, @Nullable String searchTerm) {
        return this.countAuditLogMessagesForEntity(plan.getKey(), AuditLogEntityType.PLAN, startDate, endDate, searchTerm);
    }

    public long countAuditLogMessagesForEntity(@NotNull String entityId, AuditLogEntityType entityType, long startDate, long endDate) {
        return this.auditLogDao.countAuditLogMessagesForEntity(entityId, entityType, startDate, endDate);
    }

    public long countAuditLogMessagesForEntity(@NotNull String entityId, @Nullable AuditLogEntityType entityType, long startDate, long endDate, @Nullable String searchTerm) {
        return this.auditLogDao.countAuditLogMessagesForEntity(entityId, entityType, startDate, endDate, searchTerm);
    }

    public void log(@NotNull Collection<AuditLogService.FieldChange> changes, @Nullable Key key) {
        if (key == null) {
            this.log(changes, null, null, null, null);
        } else {
            this.log(changes, key.getKey(), AuditLogEntityType.PLAN, null, null);
        }
    }

    public void log(@NotNull Iterable<AuditLogService.FieldChange> changes, @Nullable String entityId, @Nullable AuditLogEntityType entityType, @Nullable String childKey, @Nullable AuditLogEntity entity) {
        if (!this.isEnabled()) {
            return;
        }
        Date changeTime = new Date();
        String userName = this.authenticationContext.getUserNameFromSecurityContext();
        for (AuditLogService.FieldChange change : changes) {
            if (Objects.equals(change.getOldValue(), change.getNewValue())) continue;
            this.log((AuditLogEntry)new AuditLogMessage(userName, changeTime, entityType, entityId, childKey, entity, "FIELD_CHANGE", change.getFieldName(), this.maskIfNeeded(change.getFieldName(), change.getOldValue()), this.maskIfNeeded(change.getFieldName(), change.getNewValue())));
        }
    }

    public void log(@NotNull Iterable<AuditLogService.FieldChange> changes, @Nullable AuditLogEntity entity) {
        if (!this.isEnabled()) {
            return;
        }
        Date changeTime = new Date();
        String userName = this.authenticationContext.getUserNameFromSecurityContext();
        for (AuditLogService.FieldChange change : changes) {
            if (Objects.equals(change.getOldValue(), change.getNewValue())) continue;
            this.log((AuditLogEntry)new AuditLogMessage(userName, changeTime, null, null, null, entity, "FIELD_CHANGE", change.getFieldName(), this.maskIfNeeded(change.getFieldName(), change.getOldValue()), this.maskIfNeeded(change.getFieldName(), change.getNewValue())));
        }
    }

    public void log(@NotNull String fieldName, @Nullable String oldValue, @Nullable String newValue, @Nullable Key plan) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        ArrayList<AuditLogService.FieldChange> changes = new ArrayList<AuditLogService.FieldChange>();
        XmlDiffFinder.DefaultFieldChange change = new XmlDiffFinder.DefaultFieldChange(fieldName, oldValue, newValue);
        changes.add((AuditLogService.FieldChange)change);
        this.log(changes, plan);
    }

    public void log(@NotNull String fieldName, @Nullable String oldValue, @Nullable String newValue, @Nullable Key key, @Nullable AuditLogEntityType entityType, @Nullable AuditLogEntity entity) {
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        if (this.isEnabled()) {
            Date changeTime = new Date();
            EntityKeys entityKeys = new EntityKeys(key);
            this.log((AuditLogEntry)new AuditLogMessage(this.authenticationContext.getUserName(), changeTime, entityType, entityKeys.getEntityId(), entityKeys.getChildId(), entity, "FIELD_CHANGE", fieldName, this.maskIfNeeded(fieldName, oldValue), this.maskIfNeeded(fieldName, newValue)));
        }
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
            this.enabled = administrationConfiguration.isAuditLoggingEnabled();
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        administrationConfiguration.setAuditLoggingEnabled(enabled);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        this.enabled = null;
        if (enabled) {
            this.log("auditLoggingEnabled", "false", "true", null);
        }
    }

    @Nullable
    private String maskIfNeeded(@NotNull String fieldName, @Nullable String value) {
        return this.shouldBeMasked(fieldName, value) ? "********" : value;
    }

    @VisibleForTesting
    boolean shouldBeMasked(@NotNull String fieldName, @Nullable String value) {
        return PasswordMaskingUtils.shouldBeMasked((String)fieldName) || StringUtils.startsWith((CharSequence)value, (CharSequence)EncryptionService.ENCRYPTED_PRIVATE_KEY_PREFIX) || StringUtils.containsIgnoreCase((CharSequence)fieldName, (CharSequence)CONFIDENTIAL_FIELD_NAME) || OTHER_CONFIDENTIAL_FIELD_NAMES.stream().anyMatch(pattern -> StringUtils.containsIgnoreCase((CharSequence)fieldName, (CharSequence)pattern));
    }

    public List<AuditLogEntry> getAgentAuditLogsMessagesByAgentName(String agentName) {
        return this.auditLogDao.getAgentAuditLogsMessagesByAgentName(agentName);
    }

    public List<AuditLogEntry> getAgentAuditLogsMessagesByAgentName(String agentName, @Nullable String searchTerm) {
        return this.auditLogDao.getAgentAuditLogsMessagesByAgentName(agentName, searchTerm);
    }

    public boolean isRssUpdatedLog() {
        return this.isRssUpdatedLog.get();
    }

    public void setRssUpdatedLog(Boolean isRss) {
        this.isRssUpdatedLog.set(isRss);
    }

    private class LoggerRunnable
    implements Runnable {
        private final AuditLogEntry auditLogMessage;

        public LoggerRunnable(AuditLogEntry auditLogMessage) {
            this.auditLogMessage = auditLogMessage;
        }

        @Override
        public void run() {
            DefaultAuditLogService.this.auditLogDao.save((BambooObject)this.auditLogMessage);
        }
    }

    private class EntityKeys {
        private final String entityId;
        private final String childId;

        public EntityKeys(Key key) {
            String entityId = null;
            String childKey = null;
            if (key != null) {
                if (PlanKeys.isPlanKey((String)key.getKey())) {
                    PlanKey parsedKey = PlanKeys.getPlanKey((String)key.getKey());
                    PlanKey chainKeyPart = PlanKeys.getChainKeyIfJobKey((PlanKey)parsedKey);
                    if (chainKeyPart != null) {
                        entityId = chainKeyPart.getKey();
                        childKey = key.getKey();
                    } else {
                        entityId = key.getKey();
                    }
                } else if (NumberUtils.isDigits((String)key.getKey())) {
                    entityId = key.getKey();
                } else {
                    PlanKey parsedKey = PlanKeys.getPlanKey((String)key.getKey());
                    entityId = PlanKeys.getProjectKeyPart((PlanKey)parsedKey);
                    childKey = parsedKey.getPartialKey();
                }
            }
            this.entityId = entityId;
            this.childId = childKey;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public String getChildId() {
            return this.childId;
        }
    }
}

