/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildDefinitionXml;
import com.atlassian.bamboo.deployments.configuration.persistence.EnvironmentCustomConfig;
import com.atlassian.bamboo.deployments.environments.persistence.MutableEnvironment;
import com.atlassian.bamboo.deployments.projects.persistence.MutableDeploymentProject;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.persister.AuditLogTxSync;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import java.io.Serializable;
import org.hibernate.CallbackException;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate.support.ChainedInterceptorSupport;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateObjectsAuditInterceptor
extends ChainedInterceptorSupport {
    @Autowired
    @Lazy
    private AuditLogService auditLogService;
    private final InheritableThreadLocal<Boolean> methodIsRunning = new InheritableThreadLocal();

    @Override
    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) throws CallbackException {
        boolean rc = super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        if (!this.auditLogService.isEnabled()) {
            return rc;
        }
        if (Boolean.TRUE.equals(this.methodIsRunning.get())) {
            this.log.warn((Object)"Audit log Interceptor has been called inside itself. This may be indicative of bigger problems...");
            return rc;
        }
        if (this.auditLogService.isRssUpdatedLog() && SystemProperty.AUDIT_LOG_FOR_RSS_UPDATES_DISABLED.getTypedValue()) {
            this.log.debug((Object)"Audit logs for RSS updates are disabled.");
            return rc;
        }
        try {
            this.methodIsRunning.set(true);
            if (previousState == null || currentState == null || entity == null) {
                boolean bl = rc;
                return bl;
            }
            if (entity instanceof ImmutablePlan || entity instanceof BuildDefinitionXml || entity instanceof ElasticImageConfiguration || entity instanceof MutableDeploymentProject || entity instanceof MutableEnvironment || entity instanceof EnvironmentCustomConfig) {
                AuditLogTxSync txSync = this.getTxSync();
                txSync.addChanges(id, entity, currentState, previousState, propertyNames);
                txSync.registerPostCommitAction(id, txSync.createAuditLogRequestsRunnable(id, entity));
            }
        }
        catch (RuntimeException e) {
            this.log.error((Object)"Error while trying to record configuration changes", (Throwable)e);
            throw e;
        }
        finally {
            this.methodIsRunning.set(false);
        }
        return rc;
    }

    private AuditLogTxSync getTxSync() {
        for (TransactionSynchronization txSync : TransactionSynchronizationManager.getSynchronizations()) {
            AuditLogTxSync auditLogSynchronisation = (AuditLogTxSync)((Object)Narrow.downTo((Object)txSync, AuditLogTxSync.class));
            if (auditLogSynchronisation == null) continue;
            return auditLogSynchronisation;
        }
        AuditLogTxSync auditLogSynchronisation = new AuditLogTxSync(this.auditLogService);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)auditLogSynchronisation);
        return auditLogSynchronisation;
    }
}

