/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.persister;

import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityOidService;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.core.EntityWithOid;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.CallbackException;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.orm.hibernate.support.ChainedInterceptorSupport;

public class OidGenerationInterceptor
extends ChainedInterceptorSupport {
    private static final String OID_FIELD = "oid";
    @Lazy
    @Autowired
    private BambooEntityOidService bambooEntityOidService;

    @Override
    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) throws CallbackException {
        boolean stateModified = false;
        EntityWithOid entityWithOid = (EntityWithOid)Narrow.downTo((Object)entity, EntityWithOid.class);
        if (entityWithOid != null) {
            int oidIndex = ArrayUtils.indexOf((Object[])propertyNames, (Object)OID_FIELD);
            Preconditions.checkState((oidIndex != -1 ? 1 : 0) != 0, (String)"Entity class %s implementing %s does not have field '%s'", (Object)entity.getClass().getName(), (Object)BambooEntityOid.class.getName(), (Object)OID_FIELD);
            if (state[oidIndex] == null) {
                BambooEntityType entityType = entityWithOid.getEntityType();
                state[oidIndex] = this.bambooEntityOidService.nextOid(entityType);
                stateModified = true;
            }
        }
        return super.onSave(entity, id, state, propertyNames, types) || stateModified;
    }
}

